#ifndef _OPTW_NICKSERV_H_
#define _OPTW_NICKSERV_H_

//
//   File : optw_nickserv.h
//   Creation date : Fri Aug 10 2001 03:37:21 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_optionswidget.h"

#include <qlistview.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#define KVI_OPTIONS_WIDGET_ICON_KviNickServOptionsWidget KVI_SMALLICON_NICKSERV
#define KVI_OPTIONS_WIDGET_NAME_KviNickServOptionsWidget __tr_no_lookup("NickServ")
#define KVI_OPTIONS_WIDGET_PARENT_KviNickServOptionsWidget KviIrcOptionsWidget

class KviNickServOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
public:
	KviNickServOptionsWidget(QWidget * parent);
	~KviNickServOptionsWidget();
protected:
	QListView * m_pListView;
	QLineEdit * m_pNicknameEdit;
	QLineEdit * m_pServerMaskEdit;
	QLineEdit * m_pNickServMaskEdit;
	QLineEdit * m_pIdentifyCommandEdit;
	QLabel * m_pListViewLabel;
	QLabel * m_pNicknameLabel;
	QLabel * m_pServerMaskLabel;
	QLabel * m_pNickServMaskLabel;
	QLabel * m_pIdentifyCommandLabel;
	QListViewItem * m_pCurrentItem;
	KviBoolSelector * m_pEnableSelector;
	QPopupMenu * m_pContextPopup;
protected:
	void saveLastItem();
	void enableItems();
protected slots:
	void enableToggled(bool);
	void itemClicked(int btn,QListViewItem * it,const QPoint &pnt,int);
	void selectionChanged(QListViewItem * it);
	void newRule();
	void deleteRule();
public:
	virtual void commit();
};

#endif //!_OPTW_NICKSERV_H_
