//
//   File : optw_logging.cpp
//   Creation date : Mon Oct 29 15:37:16 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_logging.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviLoggingOptionsWidget::KviLoggingOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"logging_options_widget")
{
	createLayout(5,1);

	addBoolSelector(0,0,0,0,__tr("Auto-enable logging in query windows"),KviOption_boolAutoLogQueries);
	addBoolSelector(0,1,0,1,__tr("Auto-enable logging in channel windows"),KviOption_boolAutoLogChannels);
	addBoolSelector(0,2,0,2,__tr("Auto-enable logging in dcc-chat windows"),KviOption_boolAutoLogDccChat);
	addBoolSelector(0,3,0,3,__tr("Auto-enable logging in console windows"),KviOption_boolAutoLogConsole);

	addRowSpacer(0,4,0,4);
}

KviLoggingOptionsWidget::~KviLoggingOptionsWidget()
{
}



#include "m_optw_logging.moc"
