//
//   File : optw_ircview.cpp
//   Creation date : Sat Aug 11 2001 03:29:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_ircview.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviIrcViewLookOptionsWidget::KviIrcViewLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewlook_options_widget")
{
	createLayout(3,1);

	addFontSelector(0,0,0,0,__tr("Font"),KviOption_fontIrcView);
	addColorSelector(0,1,0,1,__tr("Background color"),KviOption_colorIrcViewBackground);
	addPixmapSelector(0,2,0,2,__tr("Background image"),KviOption_pixmapIrcViewBackground);

	layout()->setRowStretch(2,1);
}

KviIrcViewLookOptionsWidget::~KviIrcViewLookOptionsWidget()
{
}



KviIrcViewFeaturesOptionsWidget::KviIrcViewFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewfeatures_options_widget")
{
	createLayout(10,1);

	addBoolSelector(0,0,0,0,__tr("Show message icons"),KviOption_boolIrcViewShowImages);
	KviBoolSelector * b1 = addBoolSelector(0,1,0,1,__tr("Show timestamp"),KviOption_boolIrcViewTimestamp);
	KviBoolSelector * b2 = addBoolSelector(0,2,0,2,__tr("Use UTC timestamp"),KviOption_boolIrcViewTimestampUTC,KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp));
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	addBoolSelector(0,3,0,3,__tr("Enable URL highlighting"),KviOption_boolIrcViewUrlHighlighting);
	addBoolSelector(0,4,0,4,__tr("Use wrap margin"),KviOption_boolIrcViewWrapMargin);
	addUIntSelector(0,5,0,5,__tr("Maximum buffer size"),KviOption_uintIrcViewMaxBufferSize,32,0xFFFFFFFF,2048);
	addUIntSelector(0,6,0,6,__tr("Tool tip show timeout (in msecs)"),KviOption_uintIrcViewToolTipTimeoutInMsec,256,0xFFFFFFFF,1800);
	addUIntSelector(0,7,0,7,__tr("Tool tip hide timeout (in msecs)"),KviOption_uintIrcViewToolTipHideTimeoutInMsec,256,0xFFFFFFFF,12000);
    addBoolSelector(0,8,0,8,__tr("Draw some emoticons as real icons"),KviOption_boolDrawEmoticons);

	addRowSpacer(0,9,0,9);
}

KviIrcViewFeaturesOptionsWidget::~KviIrcViewFeaturesOptionsWidget()
{
}

#include "m_optw_ircview.moc"
