//
//   File : optw_ircoutput.cpp
//   Creation date : Wed Nov 15 2000 11:45:06 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ircoutput.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

KviIrcOutputOptionsWidget::KviIrcOutputOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircoutput_options_widget")
{
	createLayout(8,1);

	addBoolSelector(0,0,0,0,__tr("Be verbose (shows some internal actions)"),KviOption_boolBeVerbose);
	addBoolSelector(0,1,0,1,__tr("Show server pings"),KviOption_boolShowPingPong);
	addBoolSelector(0,2,0,2,__tr("Show extended server informations"),KviOption_boolShowExtendedServerInfo);
	addBoolSelector(0,3,0,3,__tr("Show own parts in the console"),KviOption_boolShowOwnParts);
	addBoolSelector(0,4,0,4,__tr("Echo the channel topic on channel join"),KviOption_boolEchoNumericTopic);
	addBoolSelector(0,5,0,5,__tr("Show compact mode changes"),KviOption_boolShowCompactModeChanges);
	addBoolSelector(0,6,0,6,__tr("Show channel sync time"),KviOption_boolShowChannelSyncTime);
	addBoolSelector(0,7,0,7,__tr("Create query for server notices"),KviOption_boolCreateQueryOnNotice);

	addRowSpacer(0,8,0,8);
}

KviIrcOutputOptionsWidget::~KviIrcOutputOptionsWidget()
{
}


#include "m_optw_ircoutput.moc"
