//
//   File : optw_irc.cpp
//   Creation date : Sun Dec  2 18:59:48 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_irc.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

KviIrcOptionsWidget::KviIrcOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"irc_options_widget")
{
	createLayout(6,1);

	QToolTip::add(
		addBoolSelector(0,0,0,0,__tr("Force brutal QUIT"),KviOption_boolForceBrutalQuit),
		__c2q(__tr("<center>This option causes KVIrc to close<br>" \
		"the connection immediately after sending the QUIT message.<br>" \
		"When this option is disabled , KVIrc will wait for the server<br>" \
		"to close the connection.<br>" \
		"Note that if you use this, your QUIT message may be not displayed.</center>")));

	addSeparator(0,1,0,1);

	QToolTip::add(
		addBoolSelector(0,2,0,2,__tr("Attempt to rejoin channel when kicked"),KviOption_boolRejoinChannelOnKick),
		__c2q(__tr("<center>This option will cause KVIrc to attempt<br>" \
		"to rejoin a channel after being kicked.</center>")));

	QToolTip::add(
		addBoolSelector(0,3,0,3,__tr("Keep channel open on KICK"),KviOption_boolKeepChannelOpenOnKick),
		__c2q(__tr("<center>This option will cause KVIrc to keep<br>" \
			"the channel window open after being kicked.<br>" \
			"It might be a good idea to activate also the<br>" \
			"\"Rejoin channel on KICK\" option.</center>")));

	QToolTip::add(
		addBoolSelector(0,4,0,4,__tr("Auto join channel on INVITE"),KviOption_boolAutoJoinOnInvite),
		__c2q(__tr("<center>This option will cause KVIrc to automatically<br>" \
			"join a channel when an INVITE message for that channel is received.<br>" \
			"Note that this may help spammers in bothering you :)</center>")));

	addRowSpacer(0,5,0,5);
}


KviIrcOptionsWidget::~KviIrcOptionsWidget()
{
}


#include "m_optw_irc.moc"
