//
//   File : optw_interfacelookglobal.cpp
//   Creation date : Sun Jun 3 2001 20:50:13 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_interfacelookglobal.h"

#include <qlayout.h>
#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_locale.h"

KviInterfaceLookGlobalOptionsWidget::KviInterfaceLookGlobalOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"interfacelookglobal_options_widget")
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	#ifdef COMPILE_KDE_SUPPORT
		createLayout(15,1);
	#else
		createLayout(14,1);
	#endif
#else
	createLayout(9,1);
#endif
	addBoolSelector(0,0,0,0,__tr("GUI Effect: Animate popup menus"),KviOption_boolUseGuiEffectAnimateMenu);
	addBoolSelector(0,1,0,1,__tr("GUI Effect: Fade popup menus"),KviOption_boolUseGuiEffectFadeMenu);
	addBoolSelector(0,2,0,2,__tr("GUI Effect: Animate tool-tips"),KviOption_boolUseGuiEffectAnimateToolTip);
	addBoolSelector(0,3,0,3,__tr("GUI Effect: Fade tool-tips"),KviOption_boolUseGuiEffectFadeToolTip);
	addBoolSelector(0,4,0,4,__tr("GUI Effect: Animate combo-boxes"),KviOption_boolUseGuiEffectAnimateCombo);

	addSeparator(0,5,0,5);

	KviBoolSelector * b = addBoolSelector(0,6,0,6,__tr("Use global application font"),KviOption_boolUseGlobalApplicationFont);

	KviFontSelector * f = addFontSelector(0,7,0,7,__tr("Global application font"),KviOption_fontApplication,
							KVI_OPTION_BOOL(KviOption_boolUseGlobalApplicationFont));

	connect(b,SIGNAL(toggled(bool)),f,SLOT(setEnabled(bool)));

#ifdef COMPILE_PSEUDO_TRANSPARENCY

	addSeparator(0,8,0,8);

	m_pUseTransparencyBoolSelector = addBoolSelector(0,9,0,9,__tr("Use pseudo transparency (use a global background image)"),KviOption_boolUseGlobalPseudoTransparency);
#ifdef COMPILE_INFO_TIPS
	#ifdef COMPILE_KDE_SUPPORT
		QToolTip::add(m_pUseTransparencyBoolSelector,
			__tr("This option makes all the KVIrc windows look " \
				"like transparent.<br>You must choose a global " \
				"background pixmap below or check the<br>" \
				"Obtain global background from KDE\" option."));
	#else
		QToolTip::add(m_pUseTransparencyBoolSelector,
			__tr("This option makes all the KVIrc windows look " \
				"like transparent.<br>You must choose also a global " \
				"background pixmap below."));
	#endif
#endif

	KviUIntSelector * u = addUIntSelector(0,10,0,10,__tr("Child fade factor"),KviOption_uintGlobalTransparencyChildFadeFactor,
							0,100,35,KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency));
	connect(m_pUseTransparencyBoolSelector,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	u = addUIntSelector(0,11,0,11,__tr("Parent fade factor"),KviOption_uintGlobalTransparencyParentFadeFactor,
							0,100,10,KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency));
	connect(m_pUseTransparencyBoolSelector,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	KviColorSelector * c = addColorSelector(0,12,0,12,__tr("Fade color"),KviOption_colorGlobalTransparencyFade,
						KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency));
	connect(m_pUseTransparencyBoolSelector,SIGNAL(toggled(bool)),c,SLOT(setEnabled(bool)));

//	addRowSpacer(0,13,0,13);
#ifdef COMPILE_KDE_SUPPORT
	m_pObtainBackgroundFromKdeBoolSelector = addBoolSelector(0,13,0,13,__tr("Obtain global background from KDE"),KviOption_boolObtainGlobalBackgroundFromKde,
				KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency));
	connect(m_pUseTransparencyBoolSelector,SIGNAL(toggled(bool)),m_pObtainBackgroundFromKdeBoolSelector,SLOT(setEnabled(bool)));

	m_pGlobalBackgroundPixmapSelector = addPixmapSelector(0,14,0,14,__tr("Global background image"),KviOption_pixmapGlobalTransparencyBackground,
				KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency) && !KVI_OPTION_BOOL(KviOption_boolObtainGlobalBackgroundFromKde));
	layout()->setRowStretch(14,1);
	connect(m_pObtainBackgroundFromKdeBoolSelector,SIGNAL(toggled(bool)),this,SLOT(enableGlobalBackgroundPixmapSelector(bool)));
#else //!COMPILE_KDE_SUPPORT
	m_pGlobalBackgroundPixmapSelector = addPixmapSelector(0,13,0,13,__tr("Global background image (you need it)"),KviOption_pixmapGlobalTransparencyBackground,
				KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency));
	layout()->setRowStretch(13,1);
#endif //!COMPILE_KDE_SUPPORT
	connect(m_pUseTransparencyBoolSelector,SIGNAL(toggled(bool)),this,SLOT(enableGlobalBackgroundPixmapSelector(bool)));

#else
	addRowSpacer(0,8,0,8);
#endif
}

KviInterfaceLookGlobalOptionsWidget::~KviInterfaceLookGlobalOptionsWidget()
{
}

void KviInterfaceLookGlobalOptionsWidget::enableGlobalBackgroundPixmapSelector(bool)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	#ifdef COMPILE_KDE_SUPPORT
		m_pGlobalBackgroundPixmapSelector->setEnabled(m_pUseTransparencyBoolSelector->isChecked() && !(m_pObtainBackgroundFromKdeBoolSelector->isChecked()));
	#else
		m_pGlobalBackgroundPixmapSelector->setEnabled(m_pUseTransparencyBoolSelector->isChecked());
	#endif
#endif
}

#include "m_optw_interfacelookglobal.moc"
