//
//   File : optw_interfacefeatures.cpp
//   Creation date : Sat Jun 2 2001 14:52:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_interfacefeatures.h"

#include <qlayout.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <string.h>

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_uparser.h"
#include "kvi_app.h"
#include "kvi_modulemanager.h"


KviInterfaceFeaturesOptionsWidget::KviInterfaceFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"interfacefeatures_options_widget")
{
	createLayout(12,2);

	addBoolSelector(0,0,1,0,__tr("Windows remember properties"),KviOption_boolWindowsRememberProperties);
	addBoolSelector(0,1,1,1,__tr("Show the options dialog as toplevel window"),KviOption_boolShowGeneralOptionsDialogAsToplevel);
	addBoolSelector(0,2,1,2,__tr("Show the script center as toplevel window"),KviOption_boolShowScriptCenterDialogAsToplevel);
	addBoolSelector(0,3,1,3,__tr("Show the registered users dialog as toplevel window"),KviOption_boolShowRegisteredUsersDialogAsToplevel);
	addBoolSelector(0,4,1,4,__tr("Show the join channels dialog as a toplevel window"),KviOption_boolShowChannelsJoinDialogAsToplevel);
	addBoolSelector(0,5,1,5,__tr("Show the servers connect dialog as a toplevel window"),KviOption_boolShowServersConnectDialogAsToplevel);
	addBoolSelector(0,6,1,6,__tr("Show the identity dialog as a toplevel window"),KviOption_boolShowIdentityDialogAsToplevel);
	addBoolSelector(0,7,1,7,__tr("Use single IRC tool bar"),KviOption_boolSingleIrcToolBar);
	addBoolSelector(0,8,1,8,__tr("Use task bar IRC-context indicator"),KviOption_boolUseTaskBarIrcContextIndicator);
	addBoolSelector(0,9,1,9,__tr("Use tree-window-list task bar"),KviOption_boolUseTreeWindowListTaskBar);

#ifndef COMPILE_ON_WINDOWS
	// FIXME: THIS OPTION WOULD NEED A SEPARATE PAGE ?
	KviModule * m = g_pModuleManager->getModule("snd");
	if(m)
	{
	    QLabel * l = new QLabel(__tr("Sound system"), this);
	    layout()->addWidget(l,10,0);

		m_pSoundSystemBox = new QComboBox(false, this);
		layout()->addWidget(m_pSoundSystemBox,10,1);

		m_pSoundSystemBox->insertItem("No sound",0);
		m_pSoundSystemBox->insertItem("Autodetect",1);
	#ifdef HAS_ESD_SUPPORT
		m_pSoundSystemBox->insertItem("EsoundD(ESD)",2);
	#endif
	#ifdef HAS_ARTS_SUPPORT    
		m_pSoundSystemBox->insertItem("KDE/ArtsD",3);
	#endif
	#ifdef HAS_OSS_SUPPORT
		m_pSoundSystemBox->insertItem("Linux/OSS",4);
	#endif
    
		m_pSoundSystemBox->setCurrentItem(KVI_OPTION_UINT(KviOption_uintSoundSystem));
	} else {
		m_pSoundSystemBox = 0;
	}
#endif //!COMPILE_ON_WINDOWS

	addRowSpacer(0,11,1,11);
}

KviInterfaceFeaturesOptionsWidget::~KviInterfaceFeaturesOptionsWidget()
{
}

void KviInterfaceFeaturesOptionsWidget::commit()
{
	KviOptionsWidget::commit();

#ifndef COMPILE_ON_WINDOWS
	if(m_pSoundSystemBox)
	{
	    KVI_OPTION_UINT(KviOption_uintSoundSystem) = m_pSoundSystemBox->currentItem();
	    //Maybe the module was already loaded, so if we have changed to 'Autodetect'
	    //we force an autodetection
	    if(KVI_OPTION_UINT(KviOption_uintSoundSystem) == 1)
		{
	        g_pUserParser->parseCommandBuffer("snd.autodetect",g_pApp->activeWindow());
	    }
	}
#endif //!COMPILE_ON_WINDOWS
}

#include "m_optw_interfacefeatures.moc"
