//
//   File : optw_input.cpp
//   Creation date : Sat Aug 11 2001 04:25:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_input.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviInputLookOptionsWidget::KviInputLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewlook_options_widget")
{
	createLayout(8,1);

	addFontSelector(0,0,0,0,__tr("Font"),KviOption_fontInput);
	addColorSelector(0,1,0,1,__tr("Background color"),KviOption_colorInputBackground);
	addColorSelector(0,2,0,2,__tr("Foreground color"),KviOption_colorInputForeground);
	addColorSelector(0,3,0,3,__tr("Selection background color"),KviOption_colorInputSelectionBackground);
	addColorSelector(0,4,0,4,__tr("Selection foreground color"),KviOption_colorInputSelectionForeground);
	addColorSelector(0,5,0,5,__tr("Control char color"),KviOption_colorInputControl);
	addColorSelector(0,6,0,6,__tr("Cursor color"),KviOption_colorInputCursor);

	addPixmapSelector(0,7,0,7,__tr("Background image"),KviOption_pixmapInputBackground);

	layout()->setRowStretch(7,1);
}

KviInputLookOptionsWidget::~KviInputLookOptionsWidget()
{
}



KviInputFeaturesOptionsWidget::KviInputFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewfeatures_options_widget")
{
	createLayout(1,1);

	addBoolSelector(0,0,0,0,__tr("Warp cursor at the end of line when browsing history"),KviOption_boolInputHistoryCursorAtEnd);

	addRowSpacer(0,1,0,1);
}

KviInputFeaturesOptionsWidget::~KviInputFeaturesOptionsWidget()
{
}

#include "m_optw_input.moc"
