//
//   File : optw_identity.cpp
//   Creation date : Tue Nov 14 2000 23:06:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_identity.h"

#include <qlayout.h>
#include <qpushbutton.h>

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_uparser.h" 
#include "kvi_app.h"
#include "kvi_window.h"
#include "kvi_console.h"

//#warning "Info tips"

KviIdentityOptionsWidget::KviIdentityOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"identity_options_widget")
{
	createLayout(8,1);

	addStringSelector(0,0,0,0,__tr("Nickname 1"),KviOption_stringNickname1);
	addStringSelector(0,1,0,1,__tr("Nickname 2"),KviOption_stringNickname2);
	addStringSelector(0,2,0,2,__tr("Nickname 3"),KviOption_stringNickname3);
	addStringSelector(0,3,0,3,__tr("Nickname 4"),KviOption_stringNickname4);
	addStringSelector(0,4,0,4,__tr("Username"),KviOption_stringUsername);
	addStringSelector(0,5,0,5,__tr("Real name"),KviOption_stringRealname);
	addSeparator(0,6,2,6);
	addPixmapSelector(0,7,2,7,__tr("Avatar image"),KviOption_pixmapMyAvatar);
	
	bool b_Iscon = g_pApp->activeWindow()->console()->isConnected();

	// It MUST be a better way to do this...
	m_pChangeButton1 = new QPushButton(__tr("Change now"),this);
	m_pChangeButton2 = new QPushButton(__tr("Change now"),this);
	m_pChangeButton3 = new QPushButton(__tr("Change now"),this);
	m_pChangeButton4 = new QPushButton(__tr("Change now"),this);

	layout()->addWidget(m_pChangeButton1,0,2);
	layout()->addWidget(m_pChangeButton2,1,2);
	layout()->addWidget(m_pChangeButton3,2,2);
	layout()->addWidget(m_pChangeButton4,3,2);

	m_pChangeButton1->setEnabled(b_Iscon);
	m_pChangeButton2->setEnabled(b_Iscon);
	m_pChangeButton3->setEnabled(b_Iscon);
	m_pChangeButton4->setEnabled(b_Iscon);

	connect(m_pChangeButton1,SIGNAL(clicked()),this,SLOT(but1Clicked()));
	connect(m_pChangeButton2,SIGNAL(clicked()),this,SLOT(but2Clicked()));
	connect(m_pChangeButton3,SIGNAL(clicked()),this,SLOT(but3Clicked()));
	connect(m_pChangeButton4,SIGNAL(clicked()),this,SLOT(but4Clicked()));
	
	layout()->setRowStretch(7,1);
}

KviIdentityOptionsWidget::~KviIdentityOptionsWidget()
{
}

void KviIdentityOptionsWidget::but1Clicked(){changeNick(1);}
void KviIdentityOptionsWidget::but2Clicked(){changeNick(2);}
void KviIdentityOptionsWidget::but3Clicked(){changeNick(3);}
void KviIdentityOptionsWidget::but4Clicked(){changeNick(4);}

void KviIdentityOptionsWidget::changeNick(short i)
{
	KviStr command;
	KviStr nick;
	switch(i)
	{
		case 1:
			nick = KVI_OPTION_STRING(KviOption_stringNickname1);
			break;
		case 2:
			nick = KVI_OPTION_STRING(KviOption_stringNickname2);
			break;
		case 3:
			nick = KVI_OPTION_STRING(KviOption_stringNickname3);
			break;
		case 4:
			nick = KVI_OPTION_STRING(KviOption_stringNickname4);
			break;
	}
	command.sprintf("nick %s",nick.ptr());
	g_pUserParser->parseCommandBuffer(command.ptr(),g_pApp->activeWindow());
}

#include "m_optw_identity.moc"
