//
//   File : optw_ident.cpp
//   Creation date : Mon Oct 29 15:48:42 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ident.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_settings.h"

//#warning "Info tips"


KviIdentOptionsWidget::KviIdentOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ident_options_widget")
{
	createLayout(8,1);

	m_pEnableIdent = addBoolSelector(0,0,0,0,__tr("Enable ident service (bad practice on UNIX!)"),KviOption_boolUseIdentService);
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),this,SLOT(enableIpv4InIpv6(bool)));

	KviStringSelector * s = addStringSelector(0,1,0,1,__tr("Ident username"),KviOption_stringIdentdUser,KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));

	KviUIntSelector * u = addUIntSelector(0,2,0,2,__tr("Service port"),KviOption_uintIdentdPort,0,65535,113,KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

#ifdef COMPILE_IPV6_SUPPORT
	m_pEnableIpv6 = addBoolSelector(0,3,0,3,__tr("Enable IpV6 service"),KviOption_boolIdentdEnableIpV6,KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),m_pEnableIpv6,SLOT(setEnabled(bool)));
	connect(m_pEnableIpv6,SIGNAL(toggled(bool)),this,SLOT(enableIpv4InIpv6(bool)));

	m_pIpv4InIpv6 = addBoolSelector(0,4,0,4,__tr("System stack treats IpV4 as part of IpV6 namespace"),KviOption_boolIdentdIpV6ContainsIpV4,KVI_OPTION_BOOL(KviOption_boolUseIdentService) && KVI_OPTION_BOOL(KviOption_boolIdentdEnableIpV6));

#else
	addSeparator(0,3,0,3);

	QLabel * l1 = addLabel(0,4,0,4,__tr("(IpV6 support is disabled: the identd will listen only on IpV4 interfaces)"));
	l1->setEnabled(KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),l1,SLOT(setEnabled(bool)));


#endif

	addSeparator(0,5,0,5);

	QLabel * l = addLabel(0,6,0,6,
#ifdef COMPILE_ON_WINDOWS
			__tr("<center>Warning: this is a <b>non RFC1413/913 compliant</b> ident daemon that implements " \
			"only a limited subset of the IDENTD service specifications. If it is possible, install a " \
			"real ident daemon.</center>")
#else
			__tr("<center>Warning: this is a <b>non RFC1413/913 compliant</b> ident daemon that implements " \
			"only a limited subset of the IDENTD service specifications.<br>" \
			"On UNIX you may also need root privileges to bind to port 113.<br>" \
			"It is definitively a good idea to use a <b>real</b> system-wide ident daemon.</center>")
#endif
	);
	l->setEnabled(KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),l,SLOT(setEnabled(bool)));


	addRowSpacer(0,7,0,7);
}

KviIdentOptionsWidget::~KviIdentOptionsWidget()
{
}

void KviIdentOptionsWidget::enableIpv4InIpv6(bool)
{
#ifdef COMPILE_IPV6_SUPPORT
	m_pIpv4InIpv6->setEnabled(m_pEnableIdent->isChecked() && m_pEnableIpv6->isChecked());
#endif
}

#include "m_optw_ident.moc"
