#ifndef _OPTW_HIGHLIGHTING_CPP_
#define _OPTW_HIGHLIGHTING_CPP_
//
//   File : optw_highlighting.cpp
//   Creation date : Sat Nov  3 18:09:35 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_highlighting.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#include <qlabel.h>



KviHighlightingOptionsWidget::KviHighlightingOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"highlighting_options_widget")
{
	createLayout(3,1);

	connect(
		m_pUseWordHighlighting = addBoolSelector(0,0,0,0,__tr("Enable word highlighting"),KviOption_boolUseWordHighlighting),
		SIGNAL(toggled(bool)),
		addStringListSelector(0,1,0,1,__tr("Highlight words"),KviOption_stringlistHighlightWords,KVI_OPTION_BOOL(KviOption_boolUseWordHighlighting)),
		SLOT(setEnabled(bool)));
	// This can be used even without Word highlighting
	m_pAlwaysHighlightNick = addBoolSelector(0,2,0,2,__tr("Always highlight messages with my nick on them"),KviOption_boolAlwaysHighlightNick);

	layout()->setRowStretch(2,2);
}

KviHighlightingOptionsWidget::~KviHighlightingOptionsWidget()
{
}


#include "m_optw_highlighting.moc"

#endif //_OPTW_HIGHLIGHTING_CPP_
