//
//   File : optw_dcc.cpp
//   Creation date : Fri Aug 17 22:08:09 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_dcc.h"

#include <qlayout.h>
#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviDccOptionsWidget::KviDccOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"dccgeneral_options_widget")
{
	createLayout(9,2);

	KviBoolSelector * b = addBoolSelector(0,0,1,0,__tr("I'm behind a firewall (or similar): can't accept incoming DCC connections"),KviOption_boolCantAcceptIncomingDccConnections);

#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("Check this option if you can't accept incoming connections<br>" \
			"KVIrc will try to use different techniques for sending and receiving files.<br>" \
			"Please note that these techniques may NOT work with other clients...")));
#endif

	KviUIntSelector * u = addUIntSelector(0,1,1,1,__tr("DCC socket timeout (secs)"),KviOption_uintDccSocketTimeout,10,65536,180);


#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("This is the time that KVIrc will wait before assuming that a DCC has failed " \
		"because the remote end is not able to connect to our listening socket.")));
#endif
	
	b = addBoolSelector(0,2,1,2,__tr("Force the following interface for listening (unless -i is used)"),KviOption_boolDccListenOnSpecifiedInterfaceByDefault);


#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("Check this option when you are on a multi-ip machine and want " \
		"to force one of the IP addresses to be used for outgoing DCCs.<br>This is especially useful " \
		"when you use IPV6 and IPV4 addresses.<br>You can force KVIrc to always choose the IpV4 interface." \
		"Fill the interface name or address below (it can be something as ppp0 too!)")));
#endif

	KviStringSelector * s = addStringSelector(0,3,1,3,__tr("Interface address (or name)"),KviOption_stringDccListenDefaultInterface,KVI_OPTION_BOOL(KviOption_boolDccListenOnSpecifiedInterfaceByDefault));

#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("This is the address or name of the interface to use by default for outgoing DCC transfers.<br>" \
		"On UNIX systems that support it , you can use also IPV4 interface names (such as ppp0).<br>" \
		"If you set it to 0.0.0.0 , KVIrc will try to find the first available IPV4 interface")));
#endif

	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));

 	b = addBoolSelector(0,4,1,4,__tr("User defined default port range"),KviOption_boolUserDefinedPortRange);

#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("Check this option if you want define a local port range for dcc")));
#endif

	u = addUIntSelector(0,5,0,5,__tr("Min"),KviOption_uintDccMinPort,1,65535,5000,KVI_OPTION_BOOL(KviOption_boolUserDefinedPortRange));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	u = addUIntSelector(1,5,1,5,__tr("Max"),KviOption_uintDccMaxPort,1,65535,30000,KVI_OPTION_BOOL(KviOption_boolUserDefinedPortRange));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	b = addBoolSelector(0,6,1,6,__tr("Always send the following fake IP (unless -a is used)"),KviOption_boolDccSendFakeAddressByDefault);

#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("Check this option if you want to always send a fake IP address in your dcc requests.<br>" \
		"This might be useful if you're behind a router that does network address translation.<br>" \
		"You will probably also need the port ranges above...")));
#endif

	s = addStringSelector(0,7,1,7,__tr("Interface address (or name)"),KviOption_stringDefaultDccFakeAddress,KVI_OPTION_BOOL(KviOption_boolDccSendFakeAddressByDefault));

#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("This is the fake address that will be sent with all the dcc requests if you check the option above")));
#endif

	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));




	addRowSpacer(0,8,1,8);
}

KviDccOptionsWidget::~KviDccOptionsWidget()
{
}


KviDccSendOptionsWidget::KviDccSendOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"dccsend_options_widget")
{
	createLayout(11,1);

	addBoolSelector(0,0,0,0,__tr("Auto accept"),KviOption_boolAutoAcceptDccSend);

	connect(
		addBoolSelector(0,1,0,1,__tr("Create minimized"),KviOption_boolCreateMinimizedDccSend),
		SIGNAL(toggled(bool)),
		addBoolSelector(0,2,0,2,__tr("Create minimized when auto-accepted (when incoming)"),KviOption_boolCreateMinimizedDccSendWhenAutoAccepted,!KVI_OPTION_BOOL(KviOption_boolCreateMinimizedDccSend)),
		SLOT(setNotEnabled(bool)));

	addBoolSelector(0,3,0,3,__tr("Auto close on success"),KviOption_boolAutoCloseDccSendOnSuccess);
	addBoolSelector(0,4,0,4,__tr("Notify success in console"),KviOption_boolNotifyDccSendSuccessInConsole);
	addBoolSelector(0,5,0,5,__tr("Use fast send (aka send ahead)"),KviOption_boolUseFastDccSend);

	addUIntSelector(0,6,0,6,__tr("Packet size (bytes)"),KviOption_uintDccSendPacketSize,16,65536,1024);
	addUIntSelector(0,7,0,7,__tr("Idle step (msecs)"),KviOption_uintDccSendIdleStepInMSec,1,65536,30);
	addBoolSelector(0,8,0,8,__tr("Send zero-byte-acknowledge (when receiving files)"),KviOption_boolSendZeroAckInDccRecv);
	addBoolSelector(0,9,0,9,__tr("Use Media-Type guessed save path"),KviOption_boolUseIncomingDccMediaTypeSavePath);

	addRowSpacer(0,10,0,10);
}

KviDccSendOptionsWidget::~KviDccSendOptionsWidget()
{
}

KviDccChatOptionsWidget::KviDccChatOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"dccchat_options_widget")
{
	createLayout(4,1);

	addBoolSelector(0,0,0,0,__tr("Auto accept"),KviOption_boolAutoAcceptDccChat);

	connect(
		addBoolSelector(0,1,0,1,__tr("Create minimized"),KviOption_boolCreateMinimizedDccChat),
		SIGNAL(toggled(bool)),
		addBoolSelector(0,2,0,2,__tr("Create minimized when auto-accepted"),KviOption_boolCreateMinimizedDccChatWhenAutoAccepted,!KVI_OPTION_BOOL(KviOption_boolCreateMinimizedDccChat)),
		SLOT(setNotEnabled(bool)));

	addRowSpacer(0,3,0,3);
}

KviDccChatOptionsWidget::~KviDccChatOptionsWidget()
{
}


KviDccVoiceOptionsWidget::KviDccVoiceOptionsWidget(QWidget *p):KviOptionsWidget(p)
{
	createLayout(9, 1);
	
	addBoolSelector(0,0,0,0, __tr("Auto accept"), KviOption_boolAutoAcceptDccVoice);
	connect(
		addBoolSelector(0,1,0,1,__tr("Create minimized"), KviOption_boolCreateMinimizedDccVoice),
		SIGNAL(toggled(bool)),
		addBoolSelector(0,2,0,2,__tr("Create minimized when auto-accepted"), KviOption_boolCreateMinimizedDccVoiceWhenAutoAccepted,!KVI_OPTION_BOOL(KviOption_boolCreateMinimizedDccVoice)),
		SLOT(setNotEnabled(bool))
	);

	addBoolSelector(0,3,0,3,__tr("Force half-duplex mode on sound device"), KviOption_boolDccVoiceForceHalfDuplex);
	addBoolSelector(0,4,0,4,__tr("Volume slider controls PCM, not Master Volume"), KviOption_boolDccVoiceVolumeSliderControlsPCM);

	addStringSelector(0,5,0,5,__tr("Sound device"), KviOption_stringDccVoiceSoundDevice);
	addStringSelector(0,6,0,6,__tr("Mixer device"), KviOption_stringDccVoiceMixerDevice);

	addUIntSelector(0,7,0,7,__tr("Pre-buffer size"), KviOption_uintDccVoicePreBufferSize, 2048, 65536, 32000);

	addRowSpacer(0,8,0,8);
}

KviDccVoiceOptionsWidget::~KviDccVoiceOptionsWidget()
{
}


#include "m_optw_dcc.moc"
