//
//   File : optw_ctcpfloodprotection.cpp
//   Creation date : Sun Jan 21 2001 14:35:06 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ctcpfloodprotection.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#include <qlabel.h>

/*
	@doc: ctcpfloodprotectionoptions
	@type:
		widget
	@title:
		Ctcp flood protection options
	@short:
		Protecting against CTCP flood
	@keyterms:
		ctcp flood
	@body:
		Here you can setup your CTCP flood protection system.[br]
		The CTCP engine in irc clients may be subjected to an external attack called "ctcp flood".[br]
		Basically, the attackers (usually there is more than one offending client) send a stream
		of CTCP requests to the victim's client; the victim attempts to satisfy all the requests
		by sending a stream of replies to the server; the server soon fills the (limited in size!) input buffer
		for the victim and thus disconnects him for "excess flood" (yes...this is the IRC protocol).[br]
		Many user defined scripts choose to completly ignore all the CTCP requests, in order to prevent such attacks.[br]
		KVIrc offers an alternative method that allows you to take advantage from the CTCP protocol
		and by the same time prevent the "ctcp flood" attack.[br]
		The method is really simple: we're going to satisfy only a limited number of CTCP requests in a defined
		time interval.[br]
		The "Use flood protection" option enables this protection method.[br]
		In the "Allow max" field you should place the maximum number of CTCP requests that KVIrc should
		satisfy in the interval of time defined in the second field (the interval is specified in seconds).[br]
		A strong protection against flood would be replying to 4 requests every 20 seconds , for example.[br]
		The minimum setting that can still protect you is sth around 3 messages every 6 seconds.[br]
		Please note that 3 messages in 6 seconds is NOT the same as 10 messages in 20 seconds:
		the first setting would allow 3 requests even in one second but then the client would
		ignore all the requests for the next 5 seconds, the second setting would allow 10 messages in one second
		and then ignore everything for the next 19 secs. 3/6 is a safer setting.[br]
		The maximum protection you can set is 0 messages in any number of seconds: KVIrc will consider any
		ctcp request as flood.[br]
		[br][br]
		You can also eventually decide to ignore specific ctcp requests: if you don't want to be PING'ed ,
		just enable the "Ignore PING requests" option.... in my opinion, it is not a great choice: it
		kills some of the IRC fun :)[br]
		[br][br]
		Some specific protection options can be set also in other ctcp options sections:
		see [widget:ctcpavatarprotooptions]ctcp avatar protocol options[/widget] and [widget:ctcpdccprotooptions]ctcp dcc protocol options[/widget].[br]
*/


KviCtcpFloodProtectionOptionsWidget::KviCtcpFloodProtectionOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ctcpfloodprotection_options_widget")
{
	createLayout(12,2);

	KviBoolSelector * b = addBoolSelector(0,0,1,0,__tr("Use flood protection"),KviOption_boolUseCtcpFloodProtection);
	KviUIntSelector * u = addUIntSelector(0,1,0,1,__tr("Allow max (0-10000)"),KviOption_uintMaxCtcpRequests,0,10000,3,KVI_OPTION_BOOL(KviOption_boolUseCtcpFloodProtection));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
	u = addUIntSelector(1,1,1,1,__tr("CTCP's in (1-3600) secs"),KviOption_uintCtcpFloodCheckInterval,1,3600,6,KVI_OPTION_BOOL(KviOption_boolUseCtcpFloodProtection));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	addSeparator(0,2,1,2);

	addBoolSelector(0,3,1,3,__tr("Ignore PING requests"),KviOption_boolIgnoreCtcpPing);
	addBoolSelector(0,4,1,4,__tr("Ignore VERSION requests"),KviOption_boolIgnoreCtcpVersion);
	addBoolSelector(0,5,1,5,__tr("Ignore CLIENTINFO requests"),KviOption_boolIgnoreCtcpClientinfo);
	addBoolSelector(0,6,1,6,__tr("Ignore USERINFO requests"),KviOption_boolIgnoreCtcpUserinfo);
	addBoolSelector(0,7,1,7,__tr("Ignore FINGER requests"),KviOption_boolIgnoreCtcpFinger);
	addBoolSelector(0,8,1,8,__tr("Ignore SOURCE requests"),KviOption_boolIgnoreCtcpSource);
	addBoolSelector(0,9,1,9,__tr("Ignore TIME requests"),KviOption_boolIgnoreCtcpTime);
	addBoolSelector(0,10,1,10,__tr("Ignore DCC/TDCC requests"),KviOption_boolIgnoreCtcpDcc);

	addRowSpacer(0,11,1,11);
}

KviCtcpFloodProtectionOptionsWidget::~KviCtcpFloodProtectionOptionsWidget()
{
}


#include "m_optw_ctcpfloodprotection.moc"
