//
//   File : optw_ctcpavatarproto.cpp
//   Creation date : Sun Jan 21 2001 16:12:06 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ctcpavatarproto.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#include <qlabel.h>

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

/*
	@doc: ctcpavatarprotooptions
	@type:
		widget
	@title:
		Ctcp avatar protocol options
	@short:
		A funnier IRC
	@keyterms:
		avatar
	@body:
		First of all you should read the [doc:ctcp_avatar]the AVATAR protocol specification[/doc].[br]
		The problems that might arise with this protocol are related to flood and spam.[br]
		You might be flooded with AVATAR requests with different filenames, and thus
		automatically reply by requesting the missing files;[br]
		The AVATR protocol might be also used for SPAM from unknown people.[br]
		KVIrc attempts to protect you from these "attacks".[br]
		The flood problem is solved by the [widget:ctcpfloodprotectionoptions]ctcp flood protection engine[/widget]:
		if you set it up, the CTCP AVATAR requests will be filtered too.[br]
		The SPAM problem has no definitive solution (just as the "common" DCC SEND or PRIVMSG spam).[br]
		The inconvenience arises when you request the missing images from the ctcp sender.[br]
		The "hard" solution is to never request missing images from other people: this can be
		set by disabling the "Request missing avatars" option.[br]
		Hard solutions are never optimal, so KVIrc uses also different strategies.[br]
		First of all, AVATAR change requests are ignored at all for users that are not well known
		(i.e. are not on a channel with you nor have an open query); this saves you from the common
		spam on channel part.
		 
		
*/

//#warning "Finish this doc"

//#warning "Set current avatar as default for registered users"

KviCtcpAvatarProtoOptionsWidget::KviCtcpAvatarProtoOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ctcpavatarproto_options_widget")
{
	createLayout(11,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr("Request missing avatars"),KviOption_boolRequestMissingAvatars);
	QToolTip::add(b,
		__c2q(__tr("<center>This option will cause KVIrc to send a DCC GET<br>" \
			"when someone sets an avatar and there is no local copy available.<br>" \
			"There is a maximum file size for the avatars that will get requested<br>" \
			"(it can be set below) , make sure that the value is not too big.</center>")));

	KviUIntSelector * u = addUIntSelector(0,1,0,1,__tr("Maximum requested avatar size (in bytes)"),KviOption_uintMaximumRequestedAvatarSize,0,1048576,102400,KVI_OPTION_BOOL(KviOption_boolRequestMissingAvatars));
	QToolTip::add(u,
		__c2q(__tr("<center>This is the maximum size for the avatars that<br>" \
			"will be automatically requested. (See option above)<br>" \
			"A reasonable value might be 102400 Bytes=100 KB</center>")));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	QToolTip::add(
		addBoolSelector(0,2,0,2,__tr("Auto accept incoming incoming avatars"),KviOption_boolAutoAcceptIncomingAvatars),
		__c2q(__tr("<center>This option will cause KVIrc to auto-accept<br>" \
			"the DCC SEND requests for incoming avatars<br>" \
			"(the ones that have been requested)<br>" \
			"If you're using the \"Request missing avatars\" option<br>" \
			"above, using this might be a good idea.<br>" \
			"The avatars will be saved in the KVIrc local directory<br>" \
			"and automatically set for the source user.</center>")));

	QToolTip::add(
		addBoolSelector(0,3,0,3,__tr("Set the last avatar as default for registered users"),KviOption_boolSetLastAvatarAsDefaultForRegisteredUsers),
		__c2q(__tr("<center>Sets the last user's avatar as default avatar-image<br>" \
			"(but only for the users that are registered.<br>")));

	addSeparator(0,4,0,4);

	QToolTip::add(
		addUIntSelector(0,5,0,5,__tr("Avatar offer timeout in seconds"),KviOption_uintAvatarOfferTimeoutInSecs,1,99999,60),
		__c2q(__tr("<center>When someone sends you a CTCP AVATAR request,<br>" \
			"KVIrc will reply with a CTCP AVATAR containing the name<br>" \
			"of your avatar file and its size.<br>" \
			"A time-limited file offer will be added for the avatar file<br>" \
			"and the requesting user (so he will be able to download your<br>" \
			"avatar by issuing a DCC GET message).<br>" \
			"This is the offer timeout: the time after that the offer will expire.</center>")));

	addSeparator(0,6,0,6);


	b = addBoolSelector(0,7,0,7,__tr("Show scaled avatar images in the userlist"),KviOption_boolScaleAvatars);
	QToolTip::add(b,__c2q(__tr("<center>This option will force KVIrc to scale the avatars<br>" \
			"to be shown in the userlist.<br>" \
			"The avatars will be scaled to fit in the bounding<br>" \
			"rectangle set below. Better keep this option on :).</center>")));

	u = addUIntSelector(0,8,0,8,__tr("Bounding rectangle width"),KviOption_uintAvatarScaleWidth,24,1024,80,KVI_OPTION_BOOL(KviOption_boolScaleAvatars));

	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
	u = addUIntSelector(0,9,0,9,__tr("Bounding rectangle height"),KviOption_uintAvatarScaleHeight,24,1024,80,KVI_OPTION_BOOL(KviOption_boolScaleAvatars));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
	addRowSpacer(0,10,0,10);
}

KviCtcpAvatarProtoOptionsWidget::~KviCtcpAvatarProtoOptionsWidget()
{
}


#include "m_optw_ctcpavatarproto.moc"
