//
//   File : optw_connection.cpp
//   Creation date : Sat Nov 24 04:25:16 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_connection.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

KviConnectionOptionsWidget::KviConnectionOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"connection_options_widget")
{

	createLayout(4,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr("Auto-reconnect on unexpected disconnect"),KviOption_boolAutoReconnectOnUnexpectedDisconnect);
#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b,__c2q(__tr("This option will enable auto-reconnecting after an unexpected disconnect.<br>" \
						"An \"unexpected disconnect\" is a termination of a <b>fully connected irc session</b><br>" \
						"that was <b>not requested by the user</b> by the means of the QUIT message.<br>" \
						"WARNING: If you use /RAW to send the QUIT message to the server<br>" \
						"this option will behave incorrectly, since it will not detect the outgoing" \
						"QUIT message and will attempt to reconnect after the server has closed the connection.<br>" \
						"For this reason , always use the /QUIT command to close your connections.<br>" \
						"This option may also behave incorrectly with bouncers that support<br>" \
						"detaching: in this case an idea could be to prepare an alias that sends the<br>" \
						"bouncer \"detach\" command and immediately after the \"quit\" command.<br>" \
						"<b>alias(bncdetach){ raw bouncer detach; quit; }</b>")));
#endif

	KviBoolSelector * b1 = addBoolSelector(0,1,0,1,__tr("Rejoin channels after reconnect"),KviOption_boolRejoinChannelsAfterReconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b1,__c2q(__tr("This option will cause KVIrc to rejoin channels after a succesfull reconnect attempt.")));
#endif

	b1 = addBoolSelector(0,2,0,2,__tr("Reopen queries after reconnect"),KviOption_boolReopenQueriesAfterReconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	QToolTip::add(b1,__c2q(__tr("This option will cause KVIrc to reopen the query windows after a succesfull reconnect attempt.")));
#endif

	addRowSpacer(0,3,0,3);
}


KviConnectionOptionsWidget::~KviConnectionOptionsWidget()
{
}


#include "m_optw_connection.moc"
