//
//   File : optw_away.cpp
//   Creation date : Mon Oct 29 15:37:16 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_away.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviAwayOptionsWidget::KviAwayOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"away_options_widget")
{
	createLayout(6,1);

	addStringSelector(0,0,0,0, __tr("Default away message"), KviOption_stringAwayMessage);

	addBoolSelector(0,1,0,1, __tr("User input exits away mode"), KviOption_boolExitAwayOnInput);

	m_pEnableAwayNick = addBoolSelector(0,2,0,2,__tr("Change nick on away"),KviOption_boolChangeNickAway);	
	connect(m_pEnableAwayNick,SIGNAL(toggled(bool)),this,SLOT(enableCustomAwayText(bool)));
	
	m_pEnableCustomAwayNick = addBoolSelector(0,3,0,3,__tr("Use auto-generated away nick (first up to 5 letters + AWAY)"),KviOption_boolAutoGeneratedAwayNick,KVI_OPTION_BOOL(KviOption_boolChangeNickAway));
	connect(m_pEnableAwayNick,SIGNAL(toggled(bool)),m_pEnableCustomAwayNick,SLOT(setEnabled(bool)));
	connect(m_pEnableCustomAwayNick,SIGNAL(toggled(bool)),this,SLOT(enableCustomAwayText(bool)));
	
	// m_p <-- stands for pointer
	// m_sz <-- stands for a string :)
//	m_szCustomAwayNick = addStringSelector(0,4,0,4,__tr("Custom away nick"),KviOption_stringCustomAwayNick,KVI_OPTION_BOOL(KviOption_boolChangeNickAway) && !(KVI_OPTION_BOOL(KviOption_boolAutoGeneratedAwayNick)));

	m_pCustomAwayNick = addStringSelector(0,4,0,4,__tr("Custom away nick"),KviOption_stringCustomAwayNick,KVI_OPTION_BOOL(KviOption_boolChangeNickAway) && !(KVI_OPTION_BOOL(KviOption_boolAutoGeneratedAwayNick)));

	addRowSpacer(0,5,0,5);
}

KviAwayOptionsWidget::~KviAwayOptionsWidget()
{
}

void KviAwayOptionsWidget::enableCustomAwayText(bool) 
{
	m_pCustomAwayNick->setEnabled(m_pEnableAwayNick->isChecked() && !(m_pEnableCustomAwayNick->isChecked()));

}


#include "m_optw_away.moc"
