#!/bin/bash

#####################################################################################################
#
# Generator for instances.h and instances.cpp
#
# This file is part of the KVirc irc client distribution
# Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
#
#####################################################################################################


echo "" > instances.h

######################################################################################################
cat >> instances.h <<EOF

#ifndef __OPTIONS_INSTANCES_H__
#define __OPTIONS_INSTANCES_H__

//
//   File : instances.h
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//
// Instance creation routines for the KVIrc options module
// DO NOT EDIT THIS FILE!! ALL CHANGES WILL BE LOST!!
// This file is automatically generated by mkcreateinstanceproc.sh
// so any change should go in that script
//

#include "kvi_optionswidget.h"
#include "kvi_module.h"
#include "kvi_list.h"

typedef struct _KviOptionsWidgetInstanceEntry KviOptionsWidgetInstanceEntry;


typedef struct _KviOptionsWidgetInstanceEntry
{
	KviOptionsWidget                          * (*createProc)(QWidget *);
	KviOptionsWidget                          * pWidget;   // singleton
	int                                         iIcon;
	const char                                * szName;
	const char                                * szClassName;
	KviPtrList<KviOptionsWidgetInstanceEntry> * pChildList;
} KviOptionsWidgetInstanceEntry;


class KviOptionsInstanceManager : public QObject
{
	Q_OBJECT
public:
	KviOptionsInstanceManager();
	virtual ~KviOptionsInstanceManager();
protected:
	KviPtrList<KviOptionsWidgetInstanceEntry> *  m_pInstanceTree;
public:
	KviPtrList<KviOptionsWidgetInstanceEntry> * instanceEntryTree(){ return m_pInstanceTree; };
	KviOptionsWidget * getInstance(KviOptionsWidgetInstanceEntry * e,QWidget * par);
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const char * clName);
	void cleanup(KviModule * m);
protected:
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const char * clName,KviPtrList<KviOptionsWidgetInstanceEntry> * l);
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const QObject * ptr,KviPtrList<KviOptionsWidgetInstanceEntry> * l);
	void deleteInstanceTree(KviPtrList<KviOptionsWidgetInstanceEntry> * l);
	void unregisterMetaObjects(KviModule * m);
protected slots:
	void widgetDestroyed();
};

#endif //__OPTIONS_INSTANCES_H__

EOF
######################################################################################################

CLASS_LIST=`grep -h "[ ]*\:[ ]*public[ ]*KviOptionsWidget" optw_*.h | sed -e 's/[ ]*\:[ ]*public[ ]*KviOptionsWidget'//g | sed -e 's/[ 	]*class[ ]*//g'`


TARGET="instances.cpp"

echo "" > $TARGET

######################################################################################################
cat >> instances.cpp <<EOF

//
//   File : instances.cpp
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//
// Instance creation routines for the KVIrc options module
// DO NOT EDIT THIS FILE!! ALL CHANGES WILL BE LOST!!
// This file is automatically generated by mkcreateinstanceproc.sh
// so any change should go in that script
//

EOF
######################################################################################################


for afile in optw_*.h; do
	echo "#include \"$afile\"" >> $TARGET
done

######################################################################################################
cat >> instances.cpp <<EOF

#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "instances.h"

int g_iOptionWidgetInstances = 0;

EOF
######################################################################################################


for aclass in $CLASS_LIST; do
	echo -n "KviOptionsWidget * class$aclass" >> $TARGET
		echo "_createInstanceProc(QWidget * parent)" >> $TARGET
	echo "{" >> $TARGET
	echo "	return new $aclass(parent);" >> $TARGET
	echo "}" >> $TARGET
	echo "" >> $TARGET
done

######################################################################################################
cat >> instances.cpp <<EOF


EOF
######################################################################################################

for aclass in $CLASS_LIST; do
	echo "static const char * g_szName_$aclass = KVI_OPTIONS_WIDGET_NAME_$aclass;" >> $TARGET
	echo "static const char * g_szClassName_$aclass = \"$aclass\";" >> $TARGET
done

######################################################################################################
cat >> instances.cpp <<EOF

KviOptionsInstanceManager::KviOptionsInstanceManager()
: QObject(0)
{

	//debug("Instantiating");
	// Create the global widget dict : case sensitive , do not copy keys
	m_pInstanceTree = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	m_pInstanceTree->setAutoDelete(true);

EOF
######################################################################################################

CLASSDIR=".classtmp"

mkdir -p $CLASSDIR

rm -f $CLASSDIR/*

for aclass in $CLASS_LIST; do
	PARENT=`grep -h "KVI_OPTIONS_WIDGET_PARENT_$aclass" optw_*.h | sed -e 's/#define//g' | sed -e s/KVI_OPTIONS_WIDGET_PARENT_$aclass//g | sed -e 's/[ ]*//g'`
	if test -z "$PARENT"; then
		PARENT="NOPARENT"
	fi
	echo $aclass >> $CLASSDIR/$PARENT
done

SPACES=""

printclass(){
	echo "" >> $TARGET
	if test -z "${DECLARED[$1]}"; then
		echo "$3	KviOptionsWidgetInstanceEntry * e$1;" >> $TARGET
		DECLARED[$1]="yes"
	fi
	echo "$3	e$1 = new KviOptionsWidgetInstanceEntry;"  >> $TARGET
	echo -n "$3	e$1->createProc = &class$2"  >> $TARGET
		echo "_createInstanceProc;"  >> $TARGET
	echo "$3	e$1->pWidget = 0;" >> $TARGET
	echo "$3	e$1->szClassName = g_szClassName_$2;" >> $TARGET
	echo "$3	e$1->iIcon = KVI_OPTIONS_WIDGET_ICON_$2;" >> $TARGET
	echo "$3	e$1->szName = __tr_no_xgettext(g_szName_$2);" >> $TARGET

	if test "$1" = "0"; then
		echo "$3	m_pInstanceTree->append(e$1);" >> $TARGET
	else
		VAL=`expr $1 - 1`
		echo "$3	e$VAL->pChildList->append(e$1);" >> $TARGET
	fi
}

addchildren(){
	if test -f $CLASSDIR/$2; then
		LEVEL[$1]=`cat $CLASSDIR/$2`
		for achild in ${LEVEL[$1]}; do
			printclass $1 $achild "$3"
			if test -f $CLASSDIR/$achild; then
				echo "" >> $TARGET
				echo "$3	e$1->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;" >> $TARGET
				echo "$3	e$1->pChildList->setAutoDelete(true);" >> $TARGET
				NEXTLEVEL=`expr $1 + 1`
				addchildren $NEXTLEVEL $achild "$3	"
			else
				echo "$3	e$1->pChildList = 0;" >> $TARGET
			fi
		done
	fi
}

addchildren 0 NOPARENT ""


rm -fr $CLASSDIR

######################################################################################################
cat >> $TARGET <<EOF

}

void KviOptionsInstanceManager::deleteInstanceTree(KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(e->pWidget)
			{
//				debug("Destroying %s",e->szName);
				if(e->pWidget->parent()->inherits("KviOptionsWidgetContainer"))
				{
//					debug("Parent inherits ok");
					disconnect(e->pWidget,SIGNAL(destroyed()),this,SLOT(widgetDestroyed()));
					delete e->pWidget->parent();
					e->pWidget =  0;
				} else {
					debug("Ops...i have deleted the options dialog ?");
				}
			} //else debug("Clas %s has no widget",e->szName);
			if(e->pChildList)deleteInstanceTree(e->pChildList);
		}
		delete l;
	}
}


KviOptionsInstanceManager::~KviOptionsInstanceManager()
{
//	debug("HERE: DESTRUCTOR");
	if(m_pInstanceTree)debug("Ops...KviOptionsInstanceManager::cleanup() not called ?");
//	debug("DESTRUCTOR : FINISHED");
}

void KviOptionsInstanceManager::cleanup(KviModule * m)
{
	deleteInstanceTree(m_pInstanceTree);
	m_pInstanceTree = 0;
	if(m)unregisterMetaObjects(m);
}

void KviOptionsInstanceManager::widgetDestroyed()
{
	KviOptionsWidgetInstanceEntry * e = findInstanceEntry(sender(),m_pInstanceTree);
	if(e)e->pWidget = 0;
	if(g_iOptionWidgetInstances > 0)g_iOptionWidgetInstances--;

}

KviOptionsWidget * KviOptionsInstanceManager::getInstance(KviOptionsWidgetInstanceEntry * e,QWidget * par)
{
	if(!e)return 0;
	if(!(e->pWidget))
	{
		e->pWidget = e->createProc(par);
		g_iOptionWidgetInstances++;
		connect(e->pWidget,SIGNAL(destroyed()),this,SLOT(widgetDestroyed()));
	}
	if(e->pWidget->parent() != par)
	{
		QWidget * oldPar = (QWidget *)e->pWidget->parent();
		e->pWidget->reparent(par,QPoint(0,0));
		delete oldPar;
	}
	return e->pWidget;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const QObject * ptr,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(ptr == e->pWidget)return e;
			if(e->pChildList)
			{
				KviOptionsWidgetInstanceEntry * e2 = findInstanceEntry(ptr,e->pChildList);
				if(e2)return e2;
			}
		}
	}
	return 0;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const char * clName,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(kvi_strEqualCI(e->szClassName,clName))return e;
			if(e->pChildList)
			{
				KviOptionsWidgetInstanceEntry * e2 = findInstanceEntry(clName,e->pChildList);
				if(e2)return e2;
			}
		}
	}
	return 0;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const char * clName)
{
	return findInstanceEntry(clName,m_pInstanceTree);
}

void KviOptionsInstanceManager::unregisterMetaObjects(KviModule * m)
{
EOF
######################################################################################################

for aclass in $CLASS_LIST; do
	echo "	m->unregisterMetaObject(\"$aclass\");" >> $TARGET
done

######################################################################################################
cat >> $TARGET <<EOF
}

#include "m_instances.moc"

EOF
######################################################################################################

