

//
//   File : instances.cpp
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//
// Instance creation routines for the KVIrc options module
// DO NOT EDIT THIS FILE!! ALL CHANGES WILL BE LOST!!
// This file is automatically generated by mkcreateinstanceproc.sh
// so any change should go in that script
//

#include "optw_antispam.h"
#include "optw_away.h"
#include "optw_connection.h"
#include "optw_ctcpavatarproto.h"
#include "optw_ctcpfloodprotection.h"
#include "optw_ctcp.h"
#include "optw_dcc.h"
#include "optw_highlighting.h"
#include "optw_ident.h"
#include "optw_identity.h"
#include "optw_ignore.h"
#include "optw_input.h"
#include "optw_interfacefeatures.h"
#include "optw_interfacelookglobal.h"
#include "optw_irc.h"
#include "optw_ircoutput.h"
#include "optw_ircview.h"
#include "optw_logging.h"
#include "optw_look.h"
#include "optw_mediatypes.h"
#include "optw_messages.h"
#include "optw_nickserv.h"
#include "optw_notify.h"
#include "optw_privmsg.h"
#include "optw_proxy.h"
#include "optw_query.h"
#include "optw_servers.h"
#include "optw_ssl.h"
#include "optw_taskbar.h"
#include "optw_texticons.h"
#include "optw_topiclabel.h"
#include "optw_transport.h"
#include "optw_uparser.h"
#include "optw_userlist.h"

#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "instances.h"

int g_iOptionWidgetInstances = 0;

KviOptionsWidget * classKviAntispamOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviAntispamOptionsWidget(parent);
}

KviOptionsWidget * classKviAwayOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviAwayOptionsWidget(parent);
}

KviOptionsWidget * classKviConnectionOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviConnectionOptionsWidget(parent);
}

KviOptionsWidget * classKviCtcpAvatarProtoOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviCtcpAvatarProtoOptionsWidget(parent);
}

KviOptionsWidget * classKviCtcpFloodProtectionOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviCtcpFloodProtectionOptionsWidget(parent);
}

KviOptionsWidget * classKviCtcpOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviCtcpOptionsWidget(parent);
}

KviOptionsWidget * classKviDccOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviDccOptionsWidget(parent);
}

KviOptionsWidget * classKviDccSendOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviDccSendOptionsWidget(parent);
}

KviOptionsWidget * classKviDccChatOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviDccChatOptionsWidget(parent);
}

KviOptionsWidget * classKviDccVoiceOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviDccVoiceOptionsWidget(parent);
}

KviOptionsWidget * classKviHighlightingOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviHighlightingOptionsWidget(parent);
}

KviOptionsWidget * classKviIdentOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIdentOptionsWidget(parent);
}

KviOptionsWidget * classKviIdentityOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIdentityOptionsWidget(parent);
}

KviOptionsWidget * classKviIgnoreOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIgnoreOptionsWidget(parent);
}

KviOptionsWidget * classKviInputLookOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviInputLookOptionsWidget(parent);
}

KviOptionsWidget * classKviInputFeaturesOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviInputFeaturesOptionsWidget(parent);
}

KviOptionsWidget * classKviInterfaceFeaturesOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviInterfaceFeaturesOptionsWidget(parent);
}

KviOptionsWidget * classKviInterfaceLookGlobalOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviInterfaceLookGlobalOptionsWidget(parent);
}

KviOptionsWidget * classKviIrcOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIrcOptionsWidget(parent);
}

KviOptionsWidget * classKviIrcOutputOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIrcOutputOptionsWidget(parent);
}

KviOptionsWidget * classKviIrcViewLookOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIrcViewLookOptionsWidget(parent);
}

KviOptionsWidget * classKviIrcViewFeaturesOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviIrcViewFeaturesOptionsWidget(parent);
}

KviOptionsWidget * classKviLoggingOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviLoggingOptionsWidget(parent);
}

KviOptionsWidget * classKviLookOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviLookOptionsWidget(parent);
}

KviOptionsWidget * classKviMediaTypesOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviMediaTypesOptionsWidget(parent);
}

KviOptionsWidget * classKviMessageOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviMessageOptionsWidget(parent);
}

KviOptionsWidget * classKviNickServOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviNickServOptionsWidget(parent);
}

KviOptionsWidget * classKviNotifyOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviNotifyOptionsWidget(parent);
}

KviOptionsWidget * classKviPrivmsgOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviPrivmsgOptionsWidget(parent);
}

KviOptionsWidget * classKviProxyOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviProxyOptionsWidget(parent);
}

KviOptionsWidget * classKviQueryOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviQueryOptionsWidget(parent);
}

KviOptionsWidget * classKviServerOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviServerOptionsWidget(parent);
}

KviOptionsWidget * classKviSSLOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviSSLOptionsWidget(parent);
}

KviOptionsWidget * classKviTaskBarOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviTaskBarOptionsWidget(parent);
}

KviOptionsWidget * classKviTreeTaskBarOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviTreeTaskBarOptionsWidget(parent);
}

KviOptionsWidget * classKviClassicTaskBarOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviClassicTaskBarOptionsWidget(parent);
}

KviOptionsWidget * classKviTextIconsOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviTextIconsOptionsWidget(parent);
}

KviOptionsWidget * classKviTopicLabelLookOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviTopicLabelLookOptionsWidget(parent);
}

KviOptionsWidget * classKviTransportOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviTransportOptionsWidget(parent);
}

KviOptionsWidget * classKviUParserOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviUParserOptionsWidget(parent);
}

KviOptionsWidget * classKviUserListLookOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviUserListLookOptionsWidget(parent);
}

KviOptionsWidget * classKviUserListFeaturesOptionsWidget_createInstanceProc(QWidget * parent)
{
	return new KviUserListFeaturesOptionsWidget(parent);
}



static const char * g_szName_KviAntispamOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviAntispamOptionsWidget;
static const char * g_szClassName_KviAntispamOptionsWidget = "KviAntispamOptionsWidget";
static const char * g_szName_KviAwayOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviAwayOptionsWidget;
static const char * g_szClassName_KviAwayOptionsWidget = "KviAwayOptionsWidget";
static const char * g_szName_KviConnectionOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviConnectionOptionsWidget;
static const char * g_szClassName_KviConnectionOptionsWidget = "KviConnectionOptionsWidget";
static const char * g_szName_KviCtcpAvatarProtoOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviCtcpAvatarProtoOptionsWidget;
static const char * g_szClassName_KviCtcpAvatarProtoOptionsWidget = "KviCtcpAvatarProtoOptionsWidget";
static const char * g_szName_KviCtcpFloodProtectionOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviCtcpFloodProtectionOptionsWidget;
static const char * g_szClassName_KviCtcpFloodProtectionOptionsWidget = "KviCtcpFloodProtectionOptionsWidget";
static const char * g_szName_KviCtcpOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviCtcpOptionsWidget;
static const char * g_szClassName_KviCtcpOptionsWidget = "KviCtcpOptionsWidget";
static const char * g_szName_KviDccOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviDccOptionsWidget;
static const char * g_szClassName_KviDccOptionsWidget = "KviDccOptionsWidget";
static const char * g_szName_KviDccSendOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviDccSendOptionsWidget;
static const char * g_szClassName_KviDccSendOptionsWidget = "KviDccSendOptionsWidget";
static const char * g_szName_KviDccChatOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviDccChatOptionsWidget;
static const char * g_szClassName_KviDccChatOptionsWidget = "KviDccChatOptionsWidget";
static const char * g_szName_KviDccVoiceOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviDccVoiceOptionsWidget;
static const char * g_szClassName_KviDccVoiceOptionsWidget = "KviDccVoiceOptionsWidget";
static const char * g_szName_KviHighlightingOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviHighlightingOptionsWidget;
static const char * g_szClassName_KviHighlightingOptionsWidget = "KviHighlightingOptionsWidget";
static const char * g_szName_KviIdentOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIdentOptionsWidget;
static const char * g_szClassName_KviIdentOptionsWidget = "KviIdentOptionsWidget";
static const char * g_szName_KviIdentityOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIdentityOptionsWidget;
static const char * g_szClassName_KviIdentityOptionsWidget = "KviIdentityOptionsWidget";
static const char * g_szName_KviIgnoreOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIgnoreOptionsWidget;
static const char * g_szClassName_KviIgnoreOptionsWidget = "KviIgnoreOptionsWidget";
static const char * g_szName_KviInputLookOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviInputLookOptionsWidget;
static const char * g_szClassName_KviInputLookOptionsWidget = "KviInputLookOptionsWidget";
static const char * g_szName_KviInputFeaturesOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviInputFeaturesOptionsWidget;
static const char * g_szClassName_KviInputFeaturesOptionsWidget = "KviInputFeaturesOptionsWidget";
static const char * g_szName_KviInterfaceFeaturesOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviInterfaceFeaturesOptionsWidget;
static const char * g_szClassName_KviInterfaceFeaturesOptionsWidget = "KviInterfaceFeaturesOptionsWidget";
static const char * g_szName_KviInterfaceLookGlobalOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviInterfaceLookGlobalOptionsWidget;
static const char * g_szClassName_KviInterfaceLookGlobalOptionsWidget = "KviInterfaceLookGlobalOptionsWidget";
static const char * g_szName_KviIrcOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIrcOptionsWidget;
static const char * g_szClassName_KviIrcOptionsWidget = "KviIrcOptionsWidget";
static const char * g_szName_KviIrcOutputOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIrcOutputOptionsWidget;
static const char * g_szClassName_KviIrcOutputOptionsWidget = "KviIrcOutputOptionsWidget";
static const char * g_szName_KviIrcViewLookOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIrcViewLookOptionsWidget;
static const char * g_szClassName_KviIrcViewLookOptionsWidget = "KviIrcViewLookOptionsWidget";
static const char * g_szName_KviIrcViewFeaturesOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviIrcViewFeaturesOptionsWidget;
static const char * g_szClassName_KviIrcViewFeaturesOptionsWidget = "KviIrcViewFeaturesOptionsWidget";
static const char * g_szName_KviLoggingOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviLoggingOptionsWidget;
static const char * g_szClassName_KviLoggingOptionsWidget = "KviLoggingOptionsWidget";
static const char * g_szName_KviLookOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviLookOptionsWidget;
static const char * g_szClassName_KviLookOptionsWidget = "KviLookOptionsWidget";
static const char * g_szName_KviMediaTypesOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviMediaTypesOptionsWidget;
static const char * g_szClassName_KviMediaTypesOptionsWidget = "KviMediaTypesOptionsWidget";
static const char * g_szName_KviMessageOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviMessageOptionsWidget;
static const char * g_szClassName_KviMessageOptionsWidget = "KviMessageOptionsWidget";
static const char * g_szName_KviNickServOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviNickServOptionsWidget;
static const char * g_szClassName_KviNickServOptionsWidget = "KviNickServOptionsWidget";
static const char * g_szName_KviNotifyOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviNotifyOptionsWidget;
static const char * g_szClassName_KviNotifyOptionsWidget = "KviNotifyOptionsWidget";
static const char * g_szName_KviPrivmsgOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviPrivmsgOptionsWidget;
static const char * g_szClassName_KviPrivmsgOptionsWidget = "KviPrivmsgOptionsWidget";
static const char * g_szName_KviProxyOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviProxyOptionsWidget;
static const char * g_szClassName_KviProxyOptionsWidget = "KviProxyOptionsWidget";
static const char * g_szName_KviQueryOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviQueryOptionsWidget;
static const char * g_szClassName_KviQueryOptionsWidget = "KviQueryOptionsWidget";
static const char * g_szName_KviServerOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviServerOptionsWidget;
static const char * g_szClassName_KviServerOptionsWidget = "KviServerOptionsWidget";
static const char * g_szName_KviSSLOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviSSLOptionsWidget;
static const char * g_szClassName_KviSSLOptionsWidget = "KviSSLOptionsWidget";
static const char * g_szName_KviTaskBarOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviTaskBarOptionsWidget;
static const char * g_szClassName_KviTaskBarOptionsWidget = "KviTaskBarOptionsWidget";
static const char * g_szName_KviTreeTaskBarOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviTreeTaskBarOptionsWidget;
static const char * g_szClassName_KviTreeTaskBarOptionsWidget = "KviTreeTaskBarOptionsWidget";
static const char * g_szName_KviClassicTaskBarOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviClassicTaskBarOptionsWidget;
static const char * g_szClassName_KviClassicTaskBarOptionsWidget = "KviClassicTaskBarOptionsWidget";
static const char * g_szName_KviTextIconsOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviTextIconsOptionsWidget;
static const char * g_szClassName_KviTextIconsOptionsWidget = "KviTextIconsOptionsWidget";
static const char * g_szName_KviTopicLabelLookOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviTopicLabelLookOptionsWidget;
static const char * g_szClassName_KviTopicLabelLookOptionsWidget = "KviTopicLabelLookOptionsWidget";
static const char * g_szName_KviTransportOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviTransportOptionsWidget;
static const char * g_szClassName_KviTransportOptionsWidget = "KviTransportOptionsWidget";
static const char * g_szName_KviUParserOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviUParserOptionsWidget;
static const char * g_szClassName_KviUParserOptionsWidget = "KviUParserOptionsWidget";
static const char * g_szName_KviUserListLookOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviUserListLookOptionsWidget;
static const char * g_szClassName_KviUserListLookOptionsWidget = "KviUserListLookOptionsWidget";
static const char * g_szName_KviUserListFeaturesOptionsWidget = KVI_OPTIONS_WIDGET_NAME_KviUserListFeaturesOptionsWidget;
static const char * g_szClassName_KviUserListFeaturesOptionsWidget = "KviUserListFeaturesOptionsWidget";

KviOptionsInstanceManager::KviOptionsInstanceManager()
: QObject(0)
{

	//debug("Instantiating");
	// Create the global widget dict : case sensitive , do not copy keys
	m_pInstanceTree = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	m_pInstanceTree->setAutoDelete(true);


	KviOptionsWidgetInstanceEntry * e0;
	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviConnectionOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviConnectionOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviConnectionOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviConnectionOptionsWidget);
	m_pInstanceTree->append(e0);

	e0->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	e0->pChildList->setAutoDelete(true);

		KviOptionsWidgetInstanceEntry * e1;
		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviIdentOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviIdentOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIdentOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviIdentOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviProxyOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviProxyOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviProxyOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviProxyOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviServerOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviServerOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviServerOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviServerOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviTransportOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviTransportOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviTransportOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviTransportOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviDccOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviDccOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviDccOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviDccOptionsWidget);
	m_pInstanceTree->append(e0);

	e0->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	e0->pChildList->setAutoDelete(true);

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviDccSendOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviDccSendOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviDccSendOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviDccSendOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviDccChatOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviDccChatOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviDccChatOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviDccChatOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviDccVoiceOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviDccVoiceOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviDccVoiceOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviDccVoiceOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviIdentityOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviIdentityOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIdentityOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviIdentityOptionsWidget);
	m_pInstanceTree->append(e0);
	e0->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviIrcOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviIrcOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIrcOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviIrcOptionsWidget);
	m_pInstanceTree->append(e0);

	e0->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	e0->pChildList->setAutoDelete(true);

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviAwayOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviAwayOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviAwayOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviAwayOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviCtcpOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviCtcpOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviCtcpOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviCtcpOptionsWidget);
		e0->pChildList->append(e1);

		e1->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
		e1->pChildList->setAutoDelete(true);

			KviOptionsWidgetInstanceEntry * e2;
			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviCtcpAvatarProtoOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviCtcpAvatarProtoOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviCtcpAvatarProtoOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviCtcpAvatarProtoOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviCtcpFloodProtectionOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviCtcpFloodProtectionOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviCtcpFloodProtectionOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviCtcpFloodProtectionOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviIgnoreOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviIgnoreOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIgnoreOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviIgnoreOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviIrcOutputOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviIrcOutputOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIrcOutputOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviIrcOutputOptionsWidget);
		e0->pChildList->append(e1);

		e1->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
		e1->pChildList->setAutoDelete(true);

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviAntispamOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviAntispamOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviAntispamOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviAntispamOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviHighlightingOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviHighlightingOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviHighlightingOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviHighlightingOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviPrivmsgOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviPrivmsgOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviPrivmsgOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviPrivmsgOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviLoggingOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviLoggingOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviLoggingOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviLoggingOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviNickServOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviNickServOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviNickServOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviNickServOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviNotifyOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviNotifyOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviNotifyOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviNotifyOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviQueryOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviQueryOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviQueryOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviQueryOptionsWidget);
		e0->pChildList->append(e1);
		e1->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviLookOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviLookOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviLookOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviLookOptionsWidget);
	m_pInstanceTree->append(e0);

	e0->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
	e0->pChildList->setAutoDelete(true);

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviInterfaceFeaturesOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviInterfaceFeaturesOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviInterfaceFeaturesOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviInterfaceFeaturesOptionsWidget);
		e0->pChildList->append(e1);

		e1->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
		e1->pChildList->setAutoDelete(true);

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviInputFeaturesOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviInputFeaturesOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviInputFeaturesOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviInputFeaturesOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviIrcViewFeaturesOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviIrcViewFeaturesOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIrcViewFeaturesOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviIrcViewFeaturesOptionsWidget);
			e1->pChildList->append(e2);

			e2->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
			e2->pChildList->setAutoDelete(true);

				KviOptionsWidgetInstanceEntry * e3;
				e3 = new KviOptionsWidgetInstanceEntry;
				e3->createProc = &classKviTextIconsOptionsWidget_createInstanceProc;
				e3->pWidget = 0;
				e3->szClassName = g_szClassName_KviTextIconsOptionsWidget;
				e3->iIcon = KVI_OPTIONS_WIDGET_ICON_KviTextIconsOptionsWidget;
				e3->szName = __tr_no_xgettext(g_szName_KviTextIconsOptionsWidget);
				e2->pChildList->append(e3);
				e3->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviUserListFeaturesOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviUserListFeaturesOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviUserListFeaturesOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviUserListFeaturesOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

		e1 = new KviOptionsWidgetInstanceEntry;
		e1->createProc = &classKviInterfaceLookGlobalOptionsWidget_createInstanceProc;
		e1->pWidget = 0;
		e1->szClassName = g_szClassName_KviInterfaceLookGlobalOptionsWidget;
		e1->iIcon = KVI_OPTIONS_WIDGET_ICON_KviInterfaceLookGlobalOptionsWidget;
		e1->szName = __tr_no_xgettext(g_szName_KviInterfaceLookGlobalOptionsWidget);
		e0->pChildList->append(e1);

		e1->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
		e1->pChildList->setAutoDelete(true);

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviInputLookOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviInputLookOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviInputLookOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviInputLookOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviIrcViewLookOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviIrcViewLookOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviIrcViewLookOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviIrcViewLookOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviMessageOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviMessageOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviMessageOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviMessageOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviTaskBarOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviTaskBarOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviTaskBarOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviTaskBarOptionsWidget);
			e1->pChildList->append(e2);

			e2->pChildList = new KviPtrList<KviOptionsWidgetInstanceEntry>;
			e2->pChildList->setAutoDelete(true);

				e3 = new KviOptionsWidgetInstanceEntry;
				e3->createProc = &classKviTreeTaskBarOptionsWidget_createInstanceProc;
				e3->pWidget = 0;
				e3->szClassName = g_szClassName_KviTreeTaskBarOptionsWidget;
				e3->iIcon = KVI_OPTIONS_WIDGET_ICON_KviTreeTaskBarOptionsWidget;
				e3->szName = __tr_no_xgettext(g_szName_KviTreeTaskBarOptionsWidget);
				e2->pChildList->append(e3);
				e3->pChildList = 0;

				e3 = new KviOptionsWidgetInstanceEntry;
				e3->createProc = &classKviClassicTaskBarOptionsWidget_createInstanceProc;
				e3->pWidget = 0;
				e3->szClassName = g_szClassName_KviClassicTaskBarOptionsWidget;
				e3->iIcon = KVI_OPTIONS_WIDGET_ICON_KviClassicTaskBarOptionsWidget;
				e3->szName = __tr_no_xgettext(g_szName_KviClassicTaskBarOptionsWidget);
				e2->pChildList->append(e3);
				e3->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviTopicLabelLookOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviTopicLabelLookOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviTopicLabelLookOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviTopicLabelLookOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

			e2 = new KviOptionsWidgetInstanceEntry;
			e2->createProc = &classKviUserListLookOptionsWidget_createInstanceProc;
			e2->pWidget = 0;
			e2->szClassName = g_szClassName_KviUserListLookOptionsWidget;
			e2->iIcon = KVI_OPTIONS_WIDGET_ICON_KviUserListLookOptionsWidget;
			e2->szName = __tr_no_xgettext(g_szName_KviUserListLookOptionsWidget);
			e1->pChildList->append(e2);
			e2->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviMediaTypesOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviMediaTypesOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviMediaTypesOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviMediaTypesOptionsWidget);
	m_pInstanceTree->append(e0);
	e0->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviSSLOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviSSLOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviSSLOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviSSLOptionsWidget);
	m_pInstanceTree->append(e0);
	e0->pChildList = 0;

	e0 = new KviOptionsWidgetInstanceEntry;
	e0->createProc = &classKviUParserOptionsWidget_createInstanceProc;
	e0->pWidget = 0;
	e0->szClassName = g_szClassName_KviUParserOptionsWidget;
	e0->iIcon = KVI_OPTIONS_WIDGET_ICON_KviUParserOptionsWidget;
	e0->szName = __tr_no_xgettext(g_szName_KviUParserOptionsWidget);
	m_pInstanceTree->append(e0);
	e0->pChildList = 0;

}

void KviOptionsInstanceManager::deleteInstanceTree(KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(e->pWidget)
			{
//				debug("Destroying %s",e->szName);
				if(e->pWidget->parent()->inherits("KviOptionsWidgetContainer"))
				{
//					debug("Parent inherits ok");
					disconnect(e->pWidget,SIGNAL(destroyed()),this,SLOT(widgetDestroyed()));
					delete e->pWidget->parent();
					e->pWidget =  0;
				} else {
					debug("Ops...i have deleted the options dialog ?");
				}
			} //else debug("Clas %s has no widget",e->szName);
			if(e->pChildList)deleteInstanceTree(e->pChildList);
		}
		delete l;
	}
}


KviOptionsInstanceManager::~KviOptionsInstanceManager()
{
//	debug("HERE: DESTRUCTOR");
	if(m_pInstanceTree)debug("Ops...KviOptionsInstanceManager::cleanup() not called ?");
//	debug("DESTRUCTOR : FINISHED");
}

void KviOptionsInstanceManager::cleanup(KviModule * m)
{
	deleteInstanceTree(m_pInstanceTree);
	m_pInstanceTree = 0;
	if(m)unregisterMetaObjects(m);
}

void KviOptionsInstanceManager::widgetDestroyed()
{
	KviOptionsWidgetInstanceEntry * e = findInstanceEntry(sender(),m_pInstanceTree);
	if(e)e->pWidget = 0;
	if(g_iOptionWidgetInstances > 0)g_iOptionWidgetInstances--;

}

KviOptionsWidget * KviOptionsInstanceManager::getInstance(KviOptionsWidgetInstanceEntry * e,QWidget * par)
{
	if(!e)return 0;
	if(!(e->pWidget))
	{
		e->pWidget = e->createProc(par);
		g_iOptionWidgetInstances++;
		connect(e->pWidget,SIGNAL(destroyed()),this,SLOT(widgetDestroyed()));
	}
	if(e->pWidget->parent() != par)
	{
		QWidget * oldPar = (QWidget *)e->pWidget->parent();
		e->pWidget->reparent(par,QPoint(0,0));
		delete oldPar;
	}
	return e->pWidget;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const QObject * ptr,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(ptr == e->pWidget)return e;
			if(e->pChildList)
			{
				KviOptionsWidgetInstanceEntry * e2 = findInstanceEntry(ptr,e->pChildList);
				if(e2)return e2;
			}
		}
	}
	return 0;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const char * clName,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(l)
	{
		for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
		{
			if(kvi_strEqualCI(e->szClassName,clName))return e;
			if(e->pChildList)
			{
				KviOptionsWidgetInstanceEntry * e2 = findInstanceEntry(clName,e->pChildList);
				if(e2)return e2;
			}
		}
	}
	return 0;
}

KviOptionsWidgetInstanceEntry * KviOptionsInstanceManager::findInstanceEntry(const char * clName)
{
	return findInstanceEntry(clName,m_pInstanceTree);
}

void KviOptionsInstanceManager::unregisterMetaObjects(KviModule * m)
{
	m->unregisterMetaObject("KviAntispamOptionsWidget");
	m->unregisterMetaObject("KviAwayOptionsWidget");
	m->unregisterMetaObject("KviConnectionOptionsWidget");
	m->unregisterMetaObject("KviCtcpAvatarProtoOptionsWidget");
	m->unregisterMetaObject("KviCtcpFloodProtectionOptionsWidget");
	m->unregisterMetaObject("KviCtcpOptionsWidget");
	m->unregisterMetaObject("KviDccOptionsWidget");
	m->unregisterMetaObject("KviDccSendOptionsWidget");
	m->unregisterMetaObject("KviDccChatOptionsWidget");
	m->unregisterMetaObject("KviDccVoiceOptionsWidget");
	m->unregisterMetaObject("KviHighlightingOptionsWidget");
	m->unregisterMetaObject("KviIdentOptionsWidget");
	m->unregisterMetaObject("KviIdentityOptionsWidget");
	m->unregisterMetaObject("KviIgnoreOptionsWidget");
	m->unregisterMetaObject("KviInputLookOptionsWidget");
	m->unregisterMetaObject("KviInputFeaturesOptionsWidget");
	m->unregisterMetaObject("KviInterfaceFeaturesOptionsWidget");
	m->unregisterMetaObject("KviInterfaceLookGlobalOptionsWidget");
	m->unregisterMetaObject("KviIrcOptionsWidget");
	m->unregisterMetaObject("KviIrcOutputOptionsWidget");
	m->unregisterMetaObject("KviIrcViewLookOptionsWidget");
	m->unregisterMetaObject("KviIrcViewFeaturesOptionsWidget");
	m->unregisterMetaObject("KviLoggingOptionsWidget");
	m->unregisterMetaObject("KviLookOptionsWidget");
	m->unregisterMetaObject("KviMediaTypesOptionsWidget");
	m->unregisterMetaObject("KviMessageOptionsWidget");
	m->unregisterMetaObject("KviNickServOptionsWidget");
	m->unregisterMetaObject("KviNotifyOptionsWidget");
	m->unregisterMetaObject("KviPrivmsgOptionsWidget");
	m->unregisterMetaObject("KviProxyOptionsWidget");
	m->unregisterMetaObject("KviQueryOptionsWidget");
	m->unregisterMetaObject("KviServerOptionsWidget");
	m->unregisterMetaObject("KviSSLOptionsWidget");
	m->unregisterMetaObject("KviTaskBarOptionsWidget");
	m->unregisterMetaObject("KviTreeTaskBarOptionsWidget");
	m->unregisterMetaObject("KviClassicTaskBarOptionsWidget");
	m->unregisterMetaObject("KviTextIconsOptionsWidget");
	m->unregisterMetaObject("KviTopicLabelLookOptionsWidget");
	m->unregisterMetaObject("KviTransportOptionsWidget");
	m->unregisterMetaObject("KviUParserOptionsWidget");
	m->unregisterMetaObject("KviUserListLookOptionsWidget");
	m->unregisterMetaObject("KviUserListFeaturesOptionsWidget");
}

#include "m_instances.moc"

