//
//   File : dlg_options.cpp
//   Creation date : Tue Jun 11 2000 02:42:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "dlg_options.h"

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_module.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>

//extern KviModule * g_pOptionsModule;
extern KviGeneralOptionsDialog * g_pGeneralOptionsDialog;

extern KviOptionsInstanceManager * g_pOptionsInstanceManager;

KviGeneralOptionsFrontWidget::KviGeneralOptionsFrontWidget(QWidget *parent)
:KviOptionsWidget(parent,"general_options_front_widget")
{
	createLayout(1,1);
#ifdef COMPILE_INFO_TIPS
	QLabel * l = new QLabel(__c2q(__tr(
					"<h1><b><center>General options</center></b></h1><br>" \
					"<hr><br>" \
					"<center>Select a category in the list view on the left " \
					"to view the related options." \
					"When you have finished click Ok to accept your changes " \
					"or Cancel to discard it. Clicking Apply will commit your" \
					"changes without closing this window.</center><br><br>" \
					"<center>Most options have a \"quick help\" feature that can be accessed " \
					"by placing the mouse over the option selector for few seconds." \
					"</center>" \
				)),this);
#else
	QLabel * l = new QLabel(__c2q(__tr(
					"<h1><b><center>General options</center></b></h1><br>" \
					"<hr><br>" \
					"<center>Select a category in the list view on the left<br>" \
					"to view the related options.<br>" \
					"When you have finished click Ok to accept your changes<br>" \
					"or Cancel to discard it.<br>Clicking Apply will commit your" \
					"changes without closing this window.<br><br>" \
					"</center>" \
				)),this);
#endif
//	l->setAlignment(AlignCenter);
	layout()->addWidget(l,0,0);
}

KviGeneralOptionsFrontWidget::~KviGeneralOptionsFrontWidget()
{
}




KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListView *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,QString(e->szName))
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListViewItem *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,QString(e->szName))
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviGeneralOptionsListViewItem::~KviGeneralOptionsListViewItem()
{
}




KviGeneralOptionsDialog::KviGeneralOptionsDialog(QWidget * par)
: QDialog(par,"general_options_dialog")
{
	setCaption(__c2q(__tr("KVIrc : general options")));
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)));

	QGridLayout * g1 = new QGridLayout(this,2,4,5,2);
	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

	g1->addMultiCellWidget(spl,0,0,0,4);

	// Controlling list view
	m_pListView = new QListView(spl);
	m_pListView->addColumn(__tr("Category"));
	m_pListView->setRootIsDecorated(true);
	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(listViewItemSelectionChanged(QListViewItem *)));


	QVBox * vbox = new QVBox(spl);

	m_pCategoryLabel = new QLabel(__tr("General options"),vbox);

	// Widget stack
	m_pWidgetStack = new QWidgetStack(vbox);
	vbox->setStretchFactor(m_pWidgetStack,1);

	// First widget visible
	KviGeneralOptionsFrontWidget *w = new KviGeneralOptionsFrontWidget(m_pWidgetStack);
	m_pWidgetStack->addWidget(w,0);
	m_pWidgetStack->raiseWidget(w);

	// Ok,Cancel,Help
	QPushButton * b = new QPushButton(__c2q(__tr("What is this ?")),this);
//	connect(b,SIGNAL(clicked()),g_pApp,SLOT(slot_whatIsThisRequest()));
	int whatIsThisWidth = b->sizeHint().width();
	g1->addWidget(b,1,1);

	b = new QPushButton(__tr("Ok"),this);
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	b->setMinimumWidth(whatIsThisWidth);
	g1->addWidget(b,1,2);	

	b = new QPushButton(__tr("Apply"),this);
    b->setDefault(true);
	b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(applyClicked()));
	g1->addWidget(b,1,3);

	b = new QPushButton(__c2q(__tr("Cancel")),this);
	b->setDefault(true);
	b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	g1->addWidget(b,1,4);

	g1->setRowStretch(0,1);
	g1->setColStretch(0,1);


	fillListView(0,g_pOptionsInstanceManager->instanceEntryTree());


	if(!parent())
	{

		if(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y() < 5)
		{
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).setY(5);
		}
		//setGeometry(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry));
		resize(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).width(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).height());
		move(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).x(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y());
	}
}

KviGeneralOptionsDialog::~KviGeneralOptionsDialog()
{
	if(!parent())KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());
	g_pGeneralOptionsDialog = 0;
//	g_pOptionsModule->unlock();
}

void KviGeneralOptionsDialog::fillListView(QListViewItem * p,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(!l)return;

	KviGeneralOptionsListViewItem * it;

	for(KviOptionsWidgetInstanceEntry * e = l->first();e;e = l->next())
	{
		if(p)it = new KviGeneralOptionsListViewItem(p,e);
		else it = new KviGeneralOptionsListViewItem(m_pListView,e);
		if(e->pChildList)fillListView(it,e->pChildList);
	}
}

void KviGeneralOptionsDialog::listViewItemSelectionChanged(QListViewItem *it)
{
	if(it)
	{
		QString str = it->text(0);
		QListViewItem * par = it->parent();

		while(par)
		{
			str.prepend(" :: ");
			str.prepend(par->text(0));
			par = par->parent();
		}

		KviGeneralOptionsListViewItem *i = (KviGeneralOptionsListViewItem *)it;
		if(!i->m_pOptionsWidget)
		{
			i->m_pOptionsWidget = g_pOptionsInstanceManager->getInstance(i->m_pInstanceEntry,m_pWidgetStack);
			m_pWidgetStack->addWidget(i->m_pOptionsWidget,0);
		}

		m_pWidgetStack->raiseWidget(i->m_pOptionsWidget);
		m_pCategoryLabel->setText(str);
	}
}

void KviGeneralOptionsDialog::applyClicked()
{
	KviGeneralOptionsListViewItem *it = (KviGeneralOptionsListViewItem *)m_pListView->firstChild();
	while(it)
	{
		recursiveCommit(it);
		it = (KviGeneralOptionsListViewItem *)it->nextSibling();
	}
}

void KviGeneralOptionsDialog::okClicked()
{
	applyClicked();
	delete this;
}

void KviGeneralOptionsDialog::cancelClicked()
{
	delete this;
}

void KviGeneralOptionsDialog::closeEvent(QCloseEvent *e)
{
	e->ignore();
	delete this;
}

void KviGeneralOptionsDialog::recursiveCommit(KviGeneralOptionsListViewItem *it)
{
	if(it->m_pOptionsWidget)it->m_pOptionsWidget->commit();

	KviGeneralOptionsListViewItem *it2 = (KviGeneralOptionsListViewItem *)it->firstChild();
	while(it2)
	{
		recursiveCommit(it2);
		it2 = (KviGeneralOptionsListViewItem *)it2->nextSibling();
	}
}

#include "m_dlg_options.moc"
