#ifndef _OFFERWINDOW_H_
#define _OFFERWINDOW_H_
//
//   File : offerwindow.h
//   Creation date : Thu Mar 28 2002 14:21:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma@kvirc.net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include "kvi_window.h"

class KviFrame;
class KviFileOffer;

class KviOfferListViewItem : public QListViewItem
{
public:
	KviOfferListViewItem(QListView * v,const char * vName,KviFileOffer * o);
	~KviOfferListViewItem();
protected:
	KviStr         m_szVisibleName;
	KviFileOffer * m_pFileOffer;
public:
	const char * visibleName(){ return m_szVisibleName.ptr(); };
	KviFileOffer * fileOffer(){ return m_pFileOffer; };
};

class KviOfferWindow : public KviWindow
{
	Q_OBJECT
public:
	KviOfferWindow(KviFrame * lpFrm);
	~KviOfferWindow();
private:
	QListView    * m_pListView;
	QWidgetStack * m_pWidgetStack;
	QWidget      * m_pAddRemovePage;
	QWidget      * m_pEditPage;
	QPushButton  * m_pAddButton;
	QPushButton  * m_pRemoveButton;
	QPushButton  * m_pRemoveAllButton;
	QPushButton  * m_pEditButton;
	QLineEdit    * m_pOfferNameEdit;
	QLineEdit    * m_pOfferFileNameEdit;
	QLineEdit    * m_pOfferMaskEdit;
	QCheckBox    * m_pOfferExpiresCheckBox;
	QLineEdit    * m_pOfferExpireTimeEdit;
protected:
	virtual void fillCaptionBuffers();
	virtual QPixmap * myIconPtr();
protected slots:
	void openHelpBrowser();
	void offerListChanged();
	void browseForFileName();
	void addOffer();
	void removeOffer();
	void removeAllOffers();
	void editOffer();
	void editOk();
	void editCancel();
	void offerExpireCheckToggled(bool bOn);
public:
	virtual QSize sizeHint() const;
};



#endif //_OFFERWINDOW_H_
