//
//   File : offerwindow.cpp
//   Creation date : Thu Mar 28 2002 14:21:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma@kvirc.net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "offerwindow.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_module.h"
#include "kvi_iconmanager.h"
#include "kvi_options.h"
#include "kvi_filetrader.h"
#include "kvi_filedialog.h"
#include "kvi_fileutils.h"
#include "kvi_time.h"
#include "kvi_uparser.h"
#include "kvi_channel.h"
#include "kvi_query.h"
#include "kvi_console.h"

#include <qlayout.h>
#include <qdatetime.h>
#include <qlayout.h>

#ifdef Unsorted
	#undef Unsorted
#endif

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif

extern KVIRC_API KviFileTrader * g_pFileTrader;
extern KviOfferWindow * g_pOfferWindow;


KviOfferListViewItem::KviOfferListViewItem(QListView * v,const char * vName,KviFileOffer * o)
: QListViewItem(v)
{
	m_szVisibleName = vName;
	m_pFileOffer = o;
	setText(0,vName);
	setText(1,o->userMask());
	if(o->expireTime())
	{
		QDateTime dt;
		dt.setTime_t(o->expireTime());
		setText(2,dt.toString());
	} else {
		setText(2,__tr("Never"));
	}
	setText(3,o->absFilePath());
}

KviOfferListViewItem::~KviOfferListViewItem()
{
}


KviOfferWindow::KviOfferWindow(KviFrame * lpFrm)
: KviWindow(KVI_WINDOW_TYPE_OFFER,lpFrm,__tr("Offer list window"))
{
	g_pOfferWindow = this;

	QGridLayout * g = new QGridLayout(this,2,1,0,0);

	m_pListView = new QListView(this);
	m_pListView->addColumn(__tr("Name"));
	m_pListView->addColumn(__tr("Mask"));
	m_pListView->addColumn(__c2q(__tr("Expires")));
	m_pListView->addColumn(__tr("File name"));
	m_pListView->setSelectionMode(QListView::Single);
#ifdef COMPILE_INFO_TIPS
	QToolTip::add(m_pListView->viewport(),__c2q(__tr("<center>Files in this list can be requested by remote users with the folliwing commandline:<br><b>CTCP &lt;yournick&gt; DCC GET &lt;name&gt;</b><br>If DCC doesn't work , XDCC can be used instead.</center>")));
#endif
	g->addWidget(m_pListView,0,0);

	m_pWidgetStack = new QWidgetStack(this);
	g->addWidget(m_pWidgetStack,1,0);

	m_pAddRemovePage = new QWidget(m_pWidgetStack);
	QGridLayout * gl = new QGridLayout(m_pAddRemovePage,2,5,2,2);
	QLabel * l = new QLabel(__tr("The files "),m_pAddRemovePage);
	gl->addMultiCellWidget(l,0,0,0,4);
	m_pAddButton = new QPushButton(__tr("Add"),m_pAddRemovePage);
	connect(m_pAddButton,SIGNAL(clicked()),this,SLOT(addOffer()));
	gl->addWidget(m_pAddButton,1,0);
	m_pEditButton = new QPushButton(__tr("Edit"),m_pAddRemovePage);
	connect(m_pEditButton,SIGNAL(clicked()),this,SLOT(editOffer()));
	gl->addWidget(m_pEditButton,1,1);
	m_pRemoveButton = new QPushButton(__tr("Remove"),m_pAddRemovePage);
	connect(m_pRemoveButton,SIGNAL(clicked()),this,SLOT(removeOffer()));
	gl->addWidget(m_pRemoveButton,1,2);
	m_pRemoveAllButton = new QPushButton(__tr("Remove all"),m_pAddRemovePage);
	connect(m_pRemoveAllButton,SIGNAL(clicked()),this,SLOT(removeAllOffers()));
	gl->addWidget(m_pRemoveAllButton,1,3);
	QPushButton * b = new QPushButton(__c2q(__tr("Help")),m_pAddRemovePage);
	connect(b,SIGNAL(clicked()),this,SLOT(openHelpBrowser()));
	gl->addWidget(b,1,4);

	gl->setRowStretch(0,1);


	m_pEditPage = new QWidget(m_pWidgetStack);
	gl = new QGridLayout(m_pEditPage,5,4,2,2);
	l = new QLabel(__tr("Name"),m_pEditPage);
	gl->addWidget(l,0,0);
	m_pOfferNameEdit = new QLineEdit(m_pEditPage);
	gl->addMultiCellWidget(m_pOfferNameEdit,0,0,1,2);
	l = new QLabel(__tr("File name"),m_pEditPage);
	gl->addWidget(l,1,0);
	m_pOfferFileNameEdit = new QLineEdit(m_pEditPage);
	gl->addMultiCellWidget(m_pOfferFileNameEdit,1,1,1,2);
	b = new QPushButton("...",m_pEditPage);
	gl->addWidget(b,1,3);
	connect(b,SIGNAL(clicked()),this,SLOT(browseForFileName()));
	l = new QLabel(__c2q(__tr("User mask")),m_pEditPage);
	gl->addWidget(l,2,0);
	m_pOfferMaskEdit = new QLineEdit(m_pEditPage);
	gl->addMultiCellWidget(m_pOfferMaskEdit,2,2,1,2);
	m_pOfferExpiresCheckBox = new QCheckBox(__c2q(__tr("Expires in")),m_pEditPage);
	connect(m_pOfferExpiresCheckBox,SIGNAL(toggled(bool)),this,SLOT(offerExpireCheckToggled(bool)));
	gl->addWidget(m_pOfferExpiresCheckBox,3,0);
	m_pOfferExpireTimeEdit = new QLineEdit(m_pEditPage);
	gl->addMultiCellWidget(m_pOfferExpireTimeEdit,3,3,1,2);
	l = new QLabel(__tr("seconds"),m_pEditPage);
	gl->addWidget(l,3,3);
	b = new QPushButton(__tr("Ok"),m_pEditPage);
	gl->addWidget(b,4,2);
	connect(b,SIGNAL(clicked()),this,SLOT(editOk()));
	b = new QPushButton(__c2q(__tr("Cancel")),m_pEditPage);
	gl->addWidget(b,4,3);
	connect(b,SIGNAL(clicked()),this,SLOT(editCancel()));
	gl->setColStretch(1,1);

	m_pWidgetStack->addWidget(m_pAddRemovePage,-1);
	m_pWidgetStack->addWidget(m_pEditPage,-1);
	m_pWidgetStack->raiseWidget(m_pAddRemovePage);

	g->setRowStretch(0,1);

	setFocusHandlerNoClass(m_pListView,this,"QLineEdit");


	connect(g_pFileTrader,SIGNAL(offerListChanged()),this,SLOT(offerListChanged()));

	offerListChanged();
}

KviOfferWindow::~KviOfferWindow()
{
	g_pOfferWindow = 0;
}

void KviOfferWindow::openHelpBrowser()
{
	g_pUserParser->parseCommandBuffer("help.open doc_file_offers.html",m_pFrm->firstConsole());
}

void KviOfferWindow::addOffer()
{
	m_pWidgetStack->raiseWidget(m_pEditPage);
	m_pOfferNameEdit->setText("");
	m_pOfferFileNameEdit->setText("");
	m_pOfferExpireTimeEdit->setText("0");
	m_pOfferMaskEdit->setText("*!*@*");
	m_pOfferExpireTimeEdit->setEnabled(false);
	m_pOfferExpiresCheckBox->setChecked(false);
}

void KviOfferWindow::editOffer()
{
	KviOfferListViewItem * it = (KviOfferListViewItem * )m_pListView->currentItem();
	if(!it)return;
	m_pOfferNameEdit->setText(it->visibleName());
	m_pOfferFileNameEdit->setText(it->text(3));
	m_pOfferMaskEdit->setText(it->text(1));
	m_pOfferExpiresCheckBox->setChecked(it->fileOffer()->expires());
	KviStr tmp;
	if(it->fileOffer()->expires())tmp.setNum(it->fileOffer()->expireTime() - time(0));
	else tmp = '0';
	m_pOfferExpireTimeEdit->setText(tmp.ptr());
	g_pFileTrader->removeOffer(it->visibleName(),it->fileOffer());
	m_pWidgetStack->raiseWidget(m_pEditPage);
}

void KviOfferWindow::removeOffer()
{
	KviOfferListViewItem * it = (KviOfferListViewItem * )m_pListView->currentItem();
	if(!it)return;
	g_pFileTrader->removeOffer(it->visibleName(),it->fileOffer());
}

void KviOfferWindow::removeAllOffers()
{
	KviOfferListViewItem * it = (KviOfferListViewItem *)m_pListView->firstChild();
	disconnect(g_pFileTrader,SIGNAL(offerListChanged()),this,SLOT(offerListChanged()));
	while(it)
	{
		g_pFileTrader->removeOffer(it->visibleName(),it->fileOffer());
		it = (KviOfferListViewItem *)(it->nextSibling());
	}
	connect(g_pFileTrader,SIGNAL(offerListChanged()),this,SLOT(offerListChanged()));
	offerListChanged();
}

void KviOfferWindow::browseForFileName()
{
	KviStr buffer;
	KviStr fName = m_pOfferFileNameEdit->text();
	kvi_adjustFilePath(fName);
	bool bStart = kvi_fileExists(fName.ptr());
	if(KviFileDialog::askForOpenFileName(buffer,__tr("Choose the file to offer"),bStart ? fName.ptr() : 0))
	{
		m_pOfferFileNameEdit->setText(buffer.ptr());
		fName = m_pOfferNameEdit->text();
		fName.stripWhiteSpace();
		if(fName.isEmpty())
		{
			buffer.cutToLast(KVI_PATH_SEPARATOR_CHAR);
			m_pOfferNameEdit->setText(buffer.ptr());
		}
	}
}

void KviOfferWindow::offerExpireCheckToggled(bool bOn)
{
	m_pOfferExpireTimeEdit->setEnabled(bOn);
}

void KviOfferWindow::editOk()
{
	KviStr szName = m_pOfferNameEdit->text();
	KviStr szPath = m_pOfferFileNameEdit->text();
	kvi_adjustFilePath(szPath);
	szName.stripWhiteSpace();
	if(szName.isEmpty())
	{
		szName = szPath;
		szName.cutToLast(KVI_PATH_SEPARATOR_CHAR);
	}
	
	KviStr szMask = m_pOfferMaskEdit->text();
	if(szMask.isEmpty())szMask = "*!*@*";
	int iExpire = 0;
	if(m_pOfferExpiresCheckBox->isChecked())
	{
		KviStr szExp = m_pOfferExpireTimeEdit->text();
		bool bOk;
		iExpire = szExp.toInt(&bOk);
		if(!bOk)iExpire = 0;
		else {
			if(iExpire < 0)iExpire = 0;
		}
	}
	g_pFileTrader->addOffer(szName.ptr(),szPath.ptr(),szMask.ptr(),iExpire);
	m_pWidgetStack->raiseWidget(m_pAddRemovePage);
}

void KviOfferWindow::editCancel()
{
	m_pWidgetStack->raiseWidget(m_pAddRemovePage);
}


void KviOfferWindow::offerListChanged()
{
	QAsciiDict<KviFileOfferList> * d = g_pFileTrader->offerListDict();

	QAsciiDict<KviFileOfferList> copy;
	copy.setAutoDelete(true);

	QAsciiDictIterator<KviFileOfferList> it(*d);

	while(KviFileOfferList * l = it.current())
	{
		KviFileOfferList * tmp = new KviFileOfferList;
		tmp->setAutoDelete(false);
		copy.insert(it.currentKey(),tmp);

		for(KviFileOffer * o = l->first();o;o = l->next())
		{
			tmp->append(o);
		}
		++it;
	}

	KviPtrList<KviOfferListViewItem> trash;
	trash.setAutoDelete(true);

	for(KviOfferListViewItem * item = (KviOfferListViewItem *)(m_pListView->firstChild());item;item = (KviOfferListViewItem *)(item->nextSibling()))
	{
		KviFileOfferList * list = copy.find(item->visibleName());
		if(list)
		{
			KviFileOffer * o;
			for(o = list->first();o;o = list->next())
			{
				if(o == item->fileOffer())
				{
					list->removeRef(o);
					if(list->count() == 0)
					{
						copy.remove(item->visibleName());
					}
					break;
				}
			}
			if(!o)trash.append(item);
		} else {
			trash.append(item);
		}
	}

	QAsciiDictIterator<KviFileOfferList> it2(copy);

	KviOfferListViewItem * newItem;

	while(KviFileOfferList * ol = it2.current())
	{
		KviStr name = it2.currentKey();
		for(KviFileOffer * fo = ol->first();fo;fo = ol->next())
		{
			newItem = new KviOfferListViewItem(m_pListView,name.ptr(),fo);
		}
		++it2;
	}
}

void KviOfferWindow::fillCaptionBuffers()
{
	m_szPlainTextCaption = __tr("Active file offer list");
	m_szHtmlActiveCaption.sprintf("<nobr><font color=\"%s\"><b>Active file offer list</b></font></nobr>",
		KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name().ascii(),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextActive2).name().ascii());
	m_szHtmlInactiveCaption.sprintf("<nobr><font color=\"%s\"><b>Active file offer list</b></font></nobr>",
		KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name().ascii(),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive2).name().ascii());
}

QSize KviOfferWindow::sizeHint() const
{
	return KviWindow::sizeHint();
}

QPixmap * KviOfferWindow::myIconPtr()
{
	return g_pIconManager->getSmallIcon(KVI_SMALLICON_OFFER);
}



#include "m_offerwindow.moc"
