//
//   File : libkviobjects.cpp
//   Creation date : Wed Sep 09 2000 20:59:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"

#include "class_button.h"
#include "class_checkbox.h"
#include "class_urllabel.h"
#include "class_lineedit.h"
#include "class_multilineedit.h"
#include "class_combobox.h"

#include "class_list.h"
#include "class_file.h"
#include "class_string.h"
#include "class_socket.h"

static KviModule * g_pObjectsModule = 0;


static bool objects_module_init(KviModule * m)
{
	g_pObjectsModule = m;

	KviScriptList::registerSelf();
	KviScriptFile::registerSelf();
	KviScriptString::registerSelf();
	KviScriptSocket::registerSelf();

	KviScriptWidget::registerSelf();
	// add new widget-inherited objects here. NOT before the previous line ;)

	KviScriptButton::registerSelf();
	KviScriptCheckBox::registerSelf();	// must be after button !
	KviScriptLabel::registerSelf();
	KviScriptUrlLabel::registerSelf();
	KviScriptLineEdit::registerSelf();
	KviScriptMLEdit::registerSelf();
	KviScriptComboBox::registerSelf();

#warning "WORK OUT A LOCKING METHOD"
#warning "UNLOCK WHEN: no more objects existing && no more derived classes"
	m->lock(); // lock self
	return true;
}

static bool objects_module_cleanup(KviModule *m)
{
	KviScriptCheckBox::unregisterSelf();
	KviScriptButton::unregisterSelf();

	KviScriptUrlLabel::unregisterSelf();
	KviScriptLabel::unregisterSelf();
	KviScriptLineEdit::unregisterSelf();
	KviScriptMLEdit::unregisterSelf();
	KviScriptComboBox::unregisterSelf();
	
	KviScriptWidget::unregisterSelf();
	
	KviScriptFile::unregisterSelf();
	KviScriptList::unregisterSelf();
	KviScriptString::unregisterSelf();
	KviScriptSocket::unregisterSelf();

	m->unregisterMetaObject("KviScriptCheckBox");
	m->unregisterMetaObject("KviScriptButton");
	m->unregisterMetaObject("KviScriptLabel");
	m->unregisterMetaObject("KviScriptUrlLabel");
	m->unregisterMetaObject("KviScriptLineEdit");
	m->unregisterMetaObject("KviScriptMLEdit");
	m->unregisterMetaObject("KviScriptComboBox");
	m->unregisterMetaObject("KviScriptWidget");
	m->unregisterMetaObject("KviScriptFile");
	m->unregisterMetaObject("KviScriptList");
	m->unregisterMetaObject("KviScriptString");
	m->unregisterMetaObject("KviScriptSocket");
	return true;
}

KviModuleInfo kvirc_module_info =
{
	"Objects",
	"1.0.0",
	"Copyright (C) 2000:\n" \
	"  Szymon Stefanek (stefanek@tin.it)\n" \
	"  Krzysztof Godlewski (kristoff@poczta.wprost.pl)",
	"Object classes for KVirc scripting language\n",
	objects_module_init,
	0,
	0,
	objects_module_cleanup
};
