#ifndef _CLASS_WIDGET_H_
#define _CLASS_WIDGET_H_
//vim: ts=8
//   File : class_widget.h
//   Creation date : Mon 11 Sep 16:34:36 CET 2000 by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_scriptobject.h"

class QWidget;

class KviScriptWidget : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptWidget(KviScriptObjectClass *c, KviScriptObject *p,
		const char * n );
	virtual ~KviScriptWidget();

	static void registerSelf();
	static void unregisterSelf();
	QWidget * widget()	{ return (QWidget *)object(); };
	QWidget * parentScriptWidget();

protected:
	virtual void init();

	// don't override this!
	virtual bool eventFilter(QObject *o,QEvent *e);

	bool functionShow(KviCommand * cmd,KviParameterList * params,
		KviStr & buffer);
	bool functionHide(KviCommand *, KviParameterList *, KviStr &);
// geometry functions
	bool functionX(KviCommand *, KviParameterList *, KviStr &);
	bool functionY(KviCommand *, KviParameterList *, KviStr &);
	bool functionWidth(KviCommand *, KviParameterList *, KviStr &);
	bool functionHeight(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMinimumWidth(KviCommand *, KviParameterList *,
		KviStr &);
	bool functionSetMinimumHeight(KviCommand *, KviParameterList *,	
		KviStr &);
	bool functionSetMaximumWidth(KviCommand *, KviParameterList *,
		KviStr &);
	bool functionSetMaximumHeight(KviCommand *, KviParameterList *,	
		KviStr &);
	bool functionGeometry(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetGeometry(KviCommand *, KviParameterList *, KviStr &);
	bool functionMove(KviCommand *, KviParameterList *, KviStr &);
	bool functionResize(KviCommand *, KviParameterList *, KviStr &);
// appearance
	bool functionIsEnabled(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetEnabled(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCaption(KviCommand *, KviParameterList *, KviStr &);
	bool functionCaption(KviCommand *, KviParameterList *, KviStr &);
	bool functionIsTopLevel(KviCommand *, KviParameterList *, KviStr &);
	bool functionIsVisible(KviCommand *, KviParameterList *, KviStr &);
	bool functionRaise(KviCommand *, KviParameterList *, KviStr &);
	bool functionLower(KviCommand *, KviParameterList *, KviStr &);
	bool functionHasFocus(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetFocus(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetBackgroundColor(KviCommand *, KviParameterList *,
		KviStr &);
	bool functionBackgroundColor(KviCommand *, KviParameterList *,KviStr &);
// other
	bool functionParentWidget(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMouseTracking(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetIcon(KviCommand *,KviParameterList *,KviStr &);
	bool functionSetBackgroundImage(KviCommand *,KviParameterList *,KviStr &);
};


#endif	// !_CLASS_WIDGET_H_
