#ifndef _CLASS_URLLABEL_H_
#define _CLASS_URLLABEL_H_
//vim: ts=8
//   File : class_urllabel.h
//   Creation date : Thu Feb 18 1:28:23 CEST 2001 by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Krzysztof Godlewski
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "class_label.h"

class KviScriptUrlLabel : public KviScriptLabel
{
	Q_OBJECT
public:
	KviScriptUrlLabel(KviScriptObjectClass *, KviScriptObject *,
		const char *);
	~KviScriptUrlLabel();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool eventFilter(QObject *, QEvent *);

	bool functionSetUrl(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetAction(KviCommand *, KviParameterList *, KviStr &);
	bool functionUrl(KviCommand *, KviParameterList *, KviStr &);
	bool functionAction(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetText(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCursorChange(KviCommand *, KviParameterList *, \
		KviStr &);
	bool functionCursorChange(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetUseSingleClick(KviCommand *, KviParameterList *, \
		KviStr &);
	bool functionUseSingleClick(KviCommand *, KviParameterList *, \
		KviStr &);

	KviStr m_url;
	KviStr m_action;

	QColor m_normalClr;
	QColor m_enterClr;
	QColor m_activeClr;

	bool m_changeCursor;
	bool m_useSingleClick;

	bool m_lastClickWasDbl;
};

#endif	// !_CLASS_URLLABEL_H_
