#ifndef _CLASS_STRING_H_
#define _CLASS_STRING_H_
//
//   File : class_string.h
//   Creation date : Sun Jul 01 2001 15:03:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_string.h"

#include "kvi_scriptobject.h"

#include "kvi_list.h"

class KviScriptString : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptString(KviScriptObjectClass * cla,KviScriptObject * par,const char * nam);
	virtual ~KviScriptString();

protected:
	KviStr m_szData;
protected:
	bool functionSetData(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionData(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionLength(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionLeft(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionRight(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionMiddle(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionCutLeft(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionCutRight(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionCut(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionToUpper(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionToLower(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionIsEmpty(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionHasData(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionHasNonWhiteSpaceData(KviCommand *c,KviParameterList * params,KviStr &buffer);
public:
	static void registerSelf();
	static void unregisterSelf();
};


#endif //_CLASS_STRING_H_
