//
//   File : class_string.cpp
//   Creation date : Sun Jul 01 2001 17:01:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_command.h"
//#include "kvi_malloc.h"
#include "kvi_locale.h"

#include "class_string.h"

#include <stdlib.h>

static KviScriptObjectClass * g_pStringClass = 0;

static KviScriptObject * stringClassCreateInstance(KviScriptObjectClass * cls,KviScriptObject *par,const char * nam)
{
	return new KviScriptString(cls,par,nam);
}

KviScriptString::KviScriptString(KviScriptObjectClass * cla,KviScriptObject * par,const char * nam)
: KviScriptObject(cla,par,nam)
{
}

KviScriptString::~KviScriptString()
{
}

/*
	@doc: string
	@keyterms:
		string object class
	@title:
		string class
	@type:
		class
	@short:
		A powerful string object class
	@inherits:
		[class]object[/class]
	@description:

	@functions:

*/


#define REG_FH(__name,__func) \
	g_pStringClass->registerFunctionHandler(__name,(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptString::__func)),0,true)


void KviScriptString::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController->lookupClass("object");
	__range_valid(base);
	g_pStringClass = new KviScriptObjectClass(base,"string",stringClassCreateInstance,true);

	REG_FH("length",functionLength);
	REG_FH("len",functionLength);
	REG_FH("setData",functionSetData);
	REG_FH("data",functionData);
	REG_FH("left",functionLeft);
	REG_FH("right",functionRight);
	REG_FH("middle",functionMiddle);
	REG_FH("cutLeft",functionCutLeft);
	REG_FH("cutRight",functionCutRight);
	REG_FH("cut",functionCut);
	REG_FH("toUpper",functionToUpper);
	REG_FH("toLower",functionToLower);
	REG_FH("isEmpty",functionIsEmpty);
	REG_FH("hasData",functionHasData);
	REG_FH("hasNonWhiteSpaceData",functionHasNonWhiteSpaceData);
}

#undef REG_FH

void KviScriptString::unregisterSelf()
{
	delete g_pStringClass; // this will delete all the objects of this class
}

bool KviScriptString::functionLength(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",m_szData.len());
	return true;
}

bool KviScriptString::functionIsEmpty(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.isEmpty() ? '1' : '0');
	return true;
}

bool KviScriptString::functionHasData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.hasData() ? '1' : '0');
	return true;
}

bool KviScriptString::functionHasNonWhiteSpaceData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.hasNonWhiteSpaceData() ? '1' : '0');
	return true;
}

bool KviScriptString::functionToUpper(KviCommand *c,KviParameterList *,KviStr &)
{
	m_szData.toUpper();
	return true;
}

bool KviScriptString::functionToLower(KviCommand *c,KviParameterList *,KviStr &)
{
	m_szData.toLower();
	return true;
}

bool KviScriptString::functionSetData(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	KviStr * pF = params->first();
	if(pF)m_szData = *pF;
	else m_szData = "";
	return true;
}

bool KviScriptString::functionData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData);
	return true;
}

bool KviScriptString::functionLeft(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_CONTEXT(c,"string::left");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else {
		if(i > m_szData.len())i = m_szData.len();
		buffer.append(m_szData.ptr(),i);
	}
	return c->leaveContext();
}

bool KviScriptString::functionRight(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_CONTEXT(c,"string::right");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else {
		if(i > m_szData.len())i = 0;
		else i = m_szData.len() - i;
		
		buffer.append(m_szData.ptr() + i);
	}
	return c->leaveContext();
}

bool KviScriptString::functionMiddle(KviCommand *c,KviParameterList *params,KviStr &buffer)
{
	ENTER_CONTEXT(c,"string::middle");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer index expected as first parameter"));
	else {
		int i2 = params->getInt(&bOk);
		if(!bOk || (i2 < 0))c->warning(__tr("Non-negative integer length expected as second parameter"));
		else {
			if(i > m_szData.len())i = m_szData.len();
			if((i + i2) > m_szData.len())i2 = m_szData.len() - i;
			buffer.append(m_szData.ptr() + i,i2);
		}
	}
	return c->leaveContext();
}

bool KviScriptString::functionCutLeft(KviCommand *c,KviParameterList * params,KviStr &)
{
	ENTER_CONTEXT(c,"string::cutLeft");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else m_szData.cutLeft(i);
	return c->leaveContext();
}

bool KviScriptString::functionCutRight(KviCommand *c,KviParameterList * params,KviStr &)
{
	ENTER_CONTEXT(c,"string::cutRight");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else m_szData.cutRight(i);
	return c->leaveContext();
}

bool KviScriptString::functionCut(KviCommand *c,KviParameterList *params,KviStr &)
{
	ENTER_CONTEXT(c,"string::cut");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer index expected as first parameter"));
	else {
		int i2 = params->getInt(&bOk);
		if(!bOk || (i2 < 0))c->warning(__tr("Non-negative integer length expected as second parameter"));
		else m_szData.cut(i,i2);
	}
	return c->leaveContext();
}

#warning "Finish the string class!"

#include "m_class_string.moc"
