#ifndef _CLASS_MULTILINEEDIT_H_
#define _CLASS_MULTILINEEDIT_H_
//vim: ts=8
//   File : class_multilineedit.h
//   Creation date : Mon Feb 19 00:45:46 CET by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "class_widget.h"
#include <qmultilineedit.h>

#warning "Signals ! (textChanged, returnPressed)"

class KviScriptMLEdit : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptMLEdit(KviScriptObjectClass *, KviScriptObject *,
		const char *);
	~KviScriptMLEdit();
	
	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual void init();

	bool functionTextLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionRemoveLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertAt(KviCommand *, KviParameterList *, KviStr &);
	bool functionNumLines(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCursorPosition(KviCommand *, KviParameterList *, \
		KviStr &);
	bool functionCursorPosition(KviCommand *, KviParameterList *, KviStr &);
	bool functionAtBeginning(KviCommand *, KviParameterList *, KviStr &);
	bool functionAtEnd(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetWordWrap(KviCommand *, KviParameterList *, KviStr &);
	bool functionWordWrap(KviCommand *, KviParameterList *, KviStr &);
	bool functionText(KviCommand *, KviParameterList *, KviStr &);
	bool functionLength(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMaxLines(KviCommand *, KviParameterList *, KviStr &);
	bool functionMaxLines(KviCommand *, KviParameterList *, KviStr &);
//	bool functionSetMaxLength(KviCommand *, KviParameterList *, KviStr &);
//	bool functionMaxLength(KviCommand *, KviParameterList *, KviStr &);

	bool functionInsert(KviCommand *, KviParameterList *, KviStr &);
	bool functionAppend(KviCommand *, KviParameterList *, KviStr &);
	bool functionCopy(KviCommand *, KviParameterList *, KviStr &);
	bool functionPaste(KviCommand *, KviParameterList *, KviStr &);
	bool functionCut(KviCommand *, KviParameterList *, KviStr &);
};

#endif	//!_CLASS_MULTILINEEDIT_H_
