#ifndef	_CLASS_LINEEDIT_H_
#define	_CLASS_LINEEDIT_H_
//vim: ts=8
//   File : class_lineedit.h
//   Creation date : Wed 20 Sep 2000 04:34:22 CEST by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include <qlineedit.h>
#include "class_widget.h"

#warning "Signals !"

class KviScriptLineEdit : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptLineEdit(KviScriptObjectClass *, KviScriptObject *,
		const char *);
	~KviScriptLineEdit();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual void init();

	bool functionText(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetText(KviCommand *, KviParameterList *, KviStr &);
	bool functionMaxLength(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMaxLength(KviCommand *, KviParameterList *, KviStr &);
	bool functionFrame(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetFrame(KviCommand *, KviParameterList *, KviStr &);
	bool functionCursorPosition(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCursorPosition(KviCommand *, KviParameterList *,
		KviStr &);
	bool functionSelectAll(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetSelection(KviCommand *, KviParameterList *, KviStr &);
	bool functionCopy(KviCommand *, KviParameterList *, KviStr &);
	bool functionCut(KviCommand *, KviParameterList *, KviStr &);
	bool functionPaste(KviCommand *, KviParameterList *, KviStr &);
	bool functionEchoMode(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetEchoMode(KviCommand *, KviParameterList *, KviStr &);
	bool functionClear(KviCommand *, KviParameterList *, KviStr &);
};

#endif	// ! _CLASS_LINEEDIT_H_
