#ifndef _CLASS_BUTTON_H_
#define _CLASS_BUTTON_H_
//
//   File : class_button.h
//   Creation date : Wed 13 Sep 2000 02:42:05 CEST by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include <qpushbutton.h>
#include "class_widget.h"

class KviScriptButton : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptButton(KviScriptObjectClass * c, KviScriptObject * parent,
		const char * name);
	virtual ~KviScriptButton();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual void init();
	
	bool functionSetText(KviCommand *, KviParameterList *, KviStr &);
	bool functionText(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetAutoDefault(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetToggleButton(KviCommand *, KviParameterList *, \
		KviStr & );
	bool functionSetOn(KviCommand *, KviParameterList *, KviStr &);
	bool functionIsOn(KviCommand *, KviParameterList *, KviStr &);
	bool functionToggle(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetIsMenuButton(KviCommand *, KviParameterList *,KviStr &);
	bool functionIsMenuButton(KviCommand *, KviParameterList *, KviStr &);

	bool functionSlotClicked(KviCommand *, KviParameterList *, KviStr &);

protected slots:
	void __slotClicked();
	void __slotToggled();
};

#endif	// !_CLASS_BUTTON_H_
