//
//   File : class_button.cpp
//   Creation date : Wed 13 Sep 2000 02:42:05 CEST by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_debug.h"
#include "kvi_scriptobject.h"
#include "kvi_command.h"
#include "kvi_error.h"

#include "class_button.h"

static KviScriptObjectClass * g_pButtonClass = 0;

static KviScriptObject * buttonClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptButton(c, p, n);
}

KviScriptButton::KviScriptButton(KviScriptObjectClass * c, KviScriptObject * p,
	const char * n) : KviScriptWidget(c, p, n)
{
}

KviScriptButton::~KviScriptButton()
{
//	debug("KviScriptButton::~KviScriptButton(%s)",id());
}

#warning "Button DOCS"
#warning "SLOTS - need a HOWTO :("

/*
	@doc: button
	@keyterms:
		button object class
	@title:
		button class
	@type:
		class
	@short:
		A simple, well-known button
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		A button - nothing more, nothing else...
		FINISH THE DOCS !
*/

void KviScriptButton::init()
{
	setObject(new QPushButton(parentScriptWidget(),name()),true);
	connect(widget(), SIGNAL(clicked()), this, SLOT(__slotClicked()));
}

#define buttonFuncReg(__nam, __func) \
	g_pButtonClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptButton::__func)), \
	0, true);

void KviScriptButton::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController->
		lookupClass("widget");
	__range_valid(base);

	g_pButtonClass = new KviScriptObjectClass(base, "button", 
		buttonClassCreateInstance, true);

	buttonFuncReg("setText", functionSetText);
	buttonFuncReg("text", functionText);
	buttonFuncReg("setAutoDefault", functionSetAutoDefault);
	buttonFuncReg("setToggleButton", functionSetToggleButton);
	buttonFuncReg("setOn", functionSetOn);
	buttonFuncReg("isOn", functionIsOn);
	buttonFuncReg("toggle", functionToggle);
	buttonFuncReg("setIsMenuButton", functionSetIsMenuButton);
	buttonFuncReg("isMenuButton", functionIsMenuButton);
// slots
//	buttonFuncReg("slotClicked", functionSlotClicked);
//	buttonFuncReg("slotClicked", __slotClicked);
	g_pButtonClass->registerEmptyFunctionHandler("slotClicked");
}

void KviScriptButton::unregisterSelf()
{
	delete g_pButtonClass;
}

bool KviScriptButton::functionSetText(KviCommand *, KviParameterList * p, \
	KviStr &)
{
	if(widget())
	{
		if(p->first())
			((QPushButton *)widget())->setText(p->first()->ptr());
		else
			((QPushButton *)widget())->setText("[!-NULL-!]");
	}
	return true;
}

bool KviScriptButton::functionText(KviCommand *, KviParameterList *, KviStr & b)
{
	if(widget())
	{
		KviStr s = ((QPushButton *)widget())->text();
		b.append(s);
	}
	return true;
}

bool KviScriptButton::functionSetAutoDefault(KviCommand *, KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setAutoDefault(p->getBool());
	}
	return true;
}

bool KviScriptButton::functionSetToggleButton(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setToggleButton(p->getBool());
	}
	return true;
}

bool KviScriptButton::functionSetOn(KviCommand *,KviParameterList * p, KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setOn(p->getBool());
	}
	return true;
}

bool KviScriptButton::functionIsOn(KviCommand *, KviParameterList *, KviStr & b)
{
	if(widget())
	{
		bool t = ((QPushButton *)widget())->isOn();
		b.append( t ? '1' : '0' );
	}
}

bool KviScriptButton::functionToggle(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->toggle();
	}
	return true;
}

bool KviScriptButton::functionSetIsMenuButton(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QPushButton *)widget())->setIsMenuButton(p->getBool());
	}
	return true;
}

bool KviScriptButton::functionIsMenuButton(KviCommand *,KviParameterList *,
	KviStr & b)
{
	if(widget())
	{
		bool t = ((QPushButton *)widget())->isMenuButton();
		b.append( t ? '1' : '0' );
	}
	return true;
}

bool KviScriptButton::functionSlotClicked(KviCommand * c, KviParameterList * p, 
	KviStr & b)
{
	debug("KviScriptButton::functionSlotClicked");
	emitSignal("clicked", &b, p, c);
	return true;
}

void KviScriptButton::__slotClicked()
{
	debug("__slotClicked");
}

void KviScriptButton::__slotToggled()
{
}

#include "m_class_button.moc"
