#ifndef _LOGVIEWWIDGET_H_
#define _LOGVIEWWIDGET_H_

//
//   File : logviewwidget.h
//   Creation date : Thue Apr 23 2002 03:01:53 CET by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2002 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_scripteditor.h"

#include <qlistview.h>


class KviScriptEditor;

class KviLogListViewItemType : public QListViewItem
{
public:
    KviLogListViewItemType(QListView * par, const char * typeName)
    : QListViewItem(par), m_szTypeName(typeName) {};
    ~KviLogListViewItemType() {};
public:
    KviStr m_szTypeName;
    virtual QString text(int col) const { return m_szTypeName.ptr(); };
    virtual const QPixmap * pixmap(int col) const;
};

class KviLogListViewItem : public QListViewItem
{
public:
    KviLogListViewItem(QListViewItem * par, const char * typeName, const char * name)
    : QListViewItem(par), m_szTypeName(typeName), m_szName(name) {};
    ~KviLogListViewItem() {};
public:
    KviStr m_szTypeName;
    KviStr m_szName;
    virtual QString text(int col) const { return m_szName.ptr(); };
    virtual QString fileName(int col) const { return NULL; };
};

class KviLogListViewLog : public QListViewItem
{
public:
    KviLogListViewLog(QListViewItem * par,const char * date, const char * fileName, const char * owner)
    : QListViewItem(par), m_szDate(date), m_szFileName(fileName), m_szOwner(owner) {};
    ~KviLogListViewLog() {};
public:
    KviStr m_szDate;
    KviStr m_szFileName;
    KviStr m_szOwner;
    virtual QString text(int col) const { return m_szDate.ptr(); };
    virtual QString fileName(int col) const { return m_szFileName.ptr(); };
    virtual QString owner(int col) const { return m_szOwner.ptr(); };
};

class KviLogViewWidget : public QWidget
{
    Q_OBJECT
public:
        KviLogViewWidget(QWidget * par);
        ~KviLogViewWidget();
protected:
        QListView       * m_pListView;
        KviScriptEditor * m_pEditor;
        QStringList     * m_pFileNames;
        KviStr            m_szLogDirectory;
protected:
        QStringList getFileNames();
        void oneTimeSetup();

protected slots:
        void itemSelected(QListViewItem * it);

public: 
        virtual void closeEvent(QCloseEvent *e);
};
#endif

