//
//   File : logviewwidget.cpp
//   Creation date : Thu Apr 23 2002 17:42:12 by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "logviewwidget.h"

#include <qsplitter.h>
#include <qlayout.h>
#include <qdir.h>

//#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_app.h"

extern QRect               g_rectLogViewGeometry;
extern KviPtrList<KviLogViewWidget> * g_pLogViewWidgetList;

const QPixmap * KviLogListViewItemType::pixmap(int col) const 
{
    if(kvi_strEqualCI(m_szTypeName.ptr(),"channel"))
        return g_pIconManager->getSmallIcon(KVI_SMALLICON_CHANNEL);
    else if(kvi_strEqualCI(m_szTypeName.ptr(),"query"))
        return g_pIconManager->getSmallIcon(KVI_SMALLICON_QUERY);
    else if(kvi_strEqualCI(m_szTypeName.ptr(),"dcc"))
        return g_pIconManager->getSmallIcon(KVI_SMALLICON_DCCMSG);
    else 
        return g_pIconManager->getSmallIcon(KVI_SMALLICON_CONSOLE);
}

KviLogViewWidget::KviLogViewWidget(QWidget * par) : QWidget(par,"logview_widget")
{

    g_pLogViewWidgetList->append(this);
    QGridLayout * l = new QGridLayout(this,1,1,2,2);

    QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

    l->addWidget(spl,0,0);

    m_pListView = new QListView(spl);
    m_pListView->addColumn(__c2q(__tr("Log")),135);
    m_pListView->setColumnWidthMode(0,QListView::Maximum);
    m_pListView->setAllColumnsShowFocus(true);
    m_pListView->setMultiSelection(false);
    m_pListView->setShowSortIndicator(true);
    m_pListView->setRootIsDecorated(true);
    connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(itemSelected(QListViewItem *)));

    // I think the script editor SSEX variant is fine there...
    m_pEditor = kvi_createScriptEditor(spl);        
    m_pEditor->setEnabled(true); //Should be enabled by default??
    
    QValueList<int> li;
    li.append(25);
    li.append(75);
    spl->setSizes(li);

    g_pApp->getLocalKvircDirectory(m_szLogDirectory,KviApp::Log);
    m_szLogDirectory.ensureLastCharIs('/'); // Does this work on Windows?

    oneTimeSetup();

    if(g_rectLogViewGeometry.y() < 5)
        g_rectLogViewGeometry.setY(5);

    resize(g_rectLogViewGeometry.width(),g_rectLogViewGeometry.height());
    move(g_rectLogViewGeometry.x(),g_rectLogViewGeometry.y());

}

KviLogViewWidget::~KviLogViewWidget()
{
    g_rectLogViewGeometry = QRect(pos().x(),pos().y(),size().width(),size().height());
    g_pLogViewWidgetList->removeRef(this);
}

void KviLogViewWidget::oneTimeSetup()
{
    KviStr tmp, lastTypeToken, lastNameToken;
    KviStr typeToken, nameToken, dateToken;
    lastTypeToken = "";
    lastNameToken = "";

    KviLogListViewItemType * typeNode;
    KviLogListViewItemType * lastTypeNode;
    KviLogListViewItem * nameNode;
    KviLogListViewItem * lastNameNode;
    KviLogListViewLog * logNode;

    QStringList m_pFileNames = getFileNames();
    m_pFileNames.sort();

    for(QStringList::Iterator it = m_pFileNames.begin(); it != m_pFileNames.end(); ++it)
    {
        tmp = (*it).ascii();
        typeToken = tmp.getToken('_');
        // Ignore non-logs files, this includes '.' and '..'
        if( (!kvi_strEqualCI(typeToken.ptr(),"channel")) && (!kvi_strEqualCI(typeToken.ptr(),"console")) && (!kvi_strEqualCI(typeToken.ptr(),"dccchat")) && (!kvi_strEqualCI(typeToken.ptr(),"query")) )
            continue;
        nameToken = tmp.getToken('_');
        dateToken = tmp;
        dateToken.cutRight(4); // '.log'

        if(typeToken == "dccchat") // 'ip.add.r_ip.add.r_'
        {
            dateToken.getToken('_');dateToken.getToken('_');
        }
        if(typeToken == lastTypeToken)
        {
            if(nameToken == lastNameToken)
                logNode = new KviLogListViewLog(lastNameNode, dateToken.ptr(),(*it).ascii(),lastNameToken.ptr());
            else // New name node (channel-#kvirc, query-Kane,...)
            {
                lastNameToken = nameToken;
                nameNode = new KviLogListViewItem(lastTypeNode,typeToken.ptr(),nameToken.ptr());
                lastNameNode = nameNode;

                logNode = new KviLogListViewLog(lastNameNode, dateToken.ptr(),(*it).ascii(),lastNameToken.ptr());
            }
        }else // New type node (channel, query...)
        {
            lastTypeToken = typeToken;
            typeNode = new KviLogListViewItemType(m_pListView,typeToken.ptr());
            lastTypeNode = typeNode;

            lastNameToken = nameToken;
            nameNode = new KviLogListViewItem(lastTypeNode,typeToken.ptr(),nameToken.ptr());
            lastNameNode = nameNode;

            logNode = new KviLogListViewLog(lastNameNode,dateToken.ptr(),(*it).ascii(),lastNameToken.ptr());
        }
    }
}

void KviLogViewWidget::itemSelected(QListViewItem * it)
{
    //A parent node
    if(!it || !it->parent() || (((KviLogListViewItem *)it)->fileName(0) == NULL))
    {
        m_pEditor->setText("");
        return;
    }

    if(((KviLogListViewItem *)it)->fileName(0) == NULL)return;

    KviStr logName = m_szLogDirectory;
    QFile logFile;

    logName.append(((KviLogListViewLog *)it)->fileName(0));
    logFile.setName(logName.ptr());

    if(!logFile.open(IO_ReadOnly))
        return;

    QString buffer;
    KviStr text;
    while(logFile.readLine(buffer,999)!= -1)
    {
        text.append(buffer);
    }
    logFile.close();
    m_pEditor->setText(text.ptr());
}

QStringList KviLogViewWidget::getFileNames()
{
    KviStr logPath;
    g_pApp->getLocalKvircDirectory(logPath,KviApp::Log);
    QString qPath(logPath.ptr());
    QDir logDir(qPath);
    return logDir.entryList();
}

void KviLogViewWidget::closeEvent(QCloseEvent *e)
{
    e->ignore();
    delete this;
}
    
#include "logviewwidget.moc"
