//
//   File : logviewmdiwindow.cpp
//   Creation date : Tue Apr 23 2002 18:08:22 by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "logviewmdiwindow.h"
#include "logviewwidget.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_module.h"
#include "kvi_options.h"

extern QRect                             g_rectLogViewGeometry; //FIXME: Use it?
extern KviPtrList<KviLogViewMDIWindow> * g_pLogViewWindowList;

KviLogViewMDIWindow::KviLogViewMDIWindow(KviFrame * lpFrm,const char * name, KviLogViewWidget * wgt)
: KviWindow(KVI_WINDOW_TYPE_LOGVIEW,lpFrm,name)
{
    g_pLogViewWindowList->append(this);
    if(wgt) this->addLogViewWidget(wgt);
    setFocusHandler(wgt,this);
}

KviLogViewMDIWindow::~KviLogViewMDIWindow()
{
    g_pLogViewWindowList->removeRef(this);
}

void KviLogViewMDIWindow::addLogViewWidget(KviLogViewWidget * wgt)
{
    m_pLogViewWidget = wgt;
}

QPixmap * KviLogViewMDIWindow::myIconPtr()
{
    return g_pIconManager->getSmallIcon(KVI_SMALLICON_LOG);
}


void KviLogViewMDIWindow::resizeEvent(QResizeEvent *e)
{
    m_pLogViewWidget->setGeometry(0,0,width(),height());
}

void KviLogViewMDIWindow::fillCaptionBuffers()
{
    m_szPlainTextCaption.sprintf(__tr("Log Viewer"));
    m_szHtmlActiveCaption.sprintf(
            __tr("<nobr><font color=\"%s\"><b>Log Viewer</b></font></nobr>"),
            KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name().ascii(),
            KVI_OPTION_COLOR(KviOption_colorCaptionTextActive2).name().ascii());
    m_szHtmlInactiveCaption.sprintf(
            KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name().ascii(),
            KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive2).name().ascii());
}

#include "logviewmdiwindow.moc"

