//
//   File : libkvilogview.cpp
//   Creation date : Sun Feb 10 2000 23:25:10 CEST by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "logviewwidget.h"
#include "logviewmdiwindow.h"
#include "kvi_config.h"

#include "kvi_module.h"
#include "kvi_uparser.h"
#include "kvi_frame.h"


KviModule        *	g_pLogViewModule = 0;
QRect               g_rectLogViewGeometry;
KviPtrList<KviLogViewMDIWindow> * g_pLogViewWindowList = 0;
KviPtrList<KviLogViewWidget> * g_pLogViewWidgetList = 0;

/*
    @doc: logview.open
    @type:
        command
    @title:
        logview.open
    @short:
        Opens a log viewer window
    @syntax:
        logview.open [-m]
    @description:
        Shows a dialog that allows the user to browse his logs in [br]
		a window with a tree structure showing the type and the date [br]
		of the logs. [br]
        If the parameter -m is used the window will be opened as a KVIrc MDI[br]
        window; otherwise it'll be opened as a normal toplevel window.
        This command is exported by the "logview" module.

  */

// ============================================
// Module stuff
// ============================================


static bool logview_module_cmd_open(KviModule *m,KviCommand *c)
{
	ENTER_CONTEXT(c,"logview_module_cmd_open");

	KviStr dummy;
    if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;
    
    if(!g_pLogViewWidgetList->isEmpty()) // Pre-existing log viewer
    {
        if(c->hasSwitch('m')) //We want it as MDI
        {
            if(g_pLogViewWidgetList->first()->parent()) // Was MDI
                g_pLogViewWindowList->first()->delayedAutoRaise();
            else // Was toplevel
            {
                KviLogViewMDIWindow * w = new KviLogViewMDIWindow(c->window()->frame(),"Log Viewer");
                g_pLogViewWidgetList->first()->reparent(w,QPoint(0,0),true);
                w->addLogViewWidget(g_pLogViewWidgetList->first());
                c->window()->frame()->addWindow(w);
            }
        } else { //We want it as toplevel
            if(g_pLogViewWidgetList->first()->parent()) // Was MDI
            {
                g_pLogViewWindowList->first()->close(true);
                KviLogViewWidget *w = new KviLogViewWidget(0);
                w->show();
                w->raise();
            } else g_pLogViewWidgetList->first()->raise();
        }
    } else 
    {
        if(c->hasSwitch('m')) // MDI
        {
            KviLogViewMDIWindow * w = new KviLogViewMDIWindow(c->window()->frame(),"Log Viewer");
            KviLogViewWidget *wid = new KviLogViewWidget(w);
            w->addLogViewWidget(wid);
            c->window()->frame()->addWindow(w);
            w->delayedAutoRaise();
           
        } else { // Toplevel
            KviLogViewWidget * w = new KviLogViewWidget(0);
            w->show();
            w->raise();
        }
    }
    
    return c->leaveContext();
}

static bool logview_module_init(KviModule * m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());
	g_rectLogViewGeometry = cfg.readRectEntry("geometry",QRect(30,30,486,398));

    g_pLogViewWindowList = new KviPtrList<KviLogViewMDIWindow>;
    g_pLogViewWindowList->setAutoDelete(false);
    g_pLogViewWidgetList = new KviPtrList<KviLogViewWidget>;
    g_pLogViewWidgetList->setAutoDelete(false);
	
	g_pLogViewModule = m;
	m->registerCommand("open", logview_module_cmd_open);
	return true;
}

static bool logview_module_cleanup(KviModule * m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());
	cfg.writeEntry("geometry",g_rectLogViewGeometry);

    while(g_pLogViewWidgetList->first()) delete g_pLogViewWidgetList->first();
    delete g_pLogViewWidgetList;
    while(g_pLogViewWindowList->first())g_pLogViewWindowList->first()->close();
    delete g_pLogViewWindowList;
    
  	m->unregisterMetaObject("KviLogViewWidget");
    m->unregisterMetaObject("KviLogViewMDIWindow");
	return true;
}

static bool logview_module_can_unload(KviModule *m)
{
    return (g_pLogViewWidgetList->isEmpty() && g_pLogViewWindowList->isEmpty());
}


// ============================================
// module definition structure
// ============================================

KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info = 
{
	"KVIrc Log Viewer Widget",
	"1.0.0",
	"Juanjo lvarez <juanjux@yahoo.es>",
	"An structured log file viewer",
	logview_module_init,
	logview_module_can_unload,
	0,
	logview_module_cleanup
};
