#ifndef _LISTWINDOW_H_
#define _LISTWINDOW_H_
//
//   File : listwindow.h
//   Creation date : Thu Oct 7 2001 13:27:55 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the lists of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_ircsocket.h"
#include "kvi_sparser.h"
#include "kvi_console.h"

#include <qlistview.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>
#include <qlineedit.h>

class KviThemedLabel;

class KviChannelListViewItem : public QListViewItem
{
public:
	KviChannelListViewItem(QListView * v,const char * szChan,const char * szUsers,const char * szTopic);
	~KviChannelListViewItem();
public:
	KviStr m_szChan;
	KviStr m_szUsers;
	KviStr m_szTopic;
	QString m_szUsersKey;
protected:
	virtual void paintCell(QPainter * p,const QColorGroup &cg,int col,int wdth,int align);
	virtual QString key(int col,bool) const;
};


class KviListWindow : public KviWindow, public KviExternalServerDataParser
{
	Q_OBJECT
public:
	KviListWindow(KviFrame * lpFrm,KviConsole * lpConsole);
	~KviListWindow();
protected:
	QSplitter      * m_pVertSplitter;
	QSplitter      * m_pTopSplitter;
	QListView      * m_pListView;
	QLineEdit      * m_pParamsEdit;
//	KviPtrList<KviLink> * m_pLinkList;
//	QPopupMenu     * m_pHostPopup;
//	KviStr           m_szRootServer;

	QToolButton    * m_pRequestButton;
	KviThemedLabel * m_pInfoLabel;
public: // Methods
	virtual void control(int msg);
	virtual void processData(KviIrcMessage * msg);
	virtual void die();
protected:
	virtual QPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void applyOptions();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
//	virtual void setProperties(KviWindowProperty *p);
//	virtual void saveProperties();
protected slots:
	void itemDoubleClicked(QListViewItem *it);
	void requestList();
	void connectionStateChange(KviConsole::ConnectionState st);
public:
	virtual QSize sizeHint() const;
private:
	void reset();
	void endOfList();
	void startOfList();
};

#endif //_KVI_LISTWINDOW_H_
