//
//   File : helpwidget.cpp
//   Creation date : Thu Aug 10 2000 17:42:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "helpwidget.h"

#include "kvi_frame.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_process.h"
#include "kvi_app.h"
#include "kvi_msgbox.h"
#include "kvi_module.h"

#include "helpwindow.h"

#include <qtoolbutton.h>
#include <qlineedit.h>
#include <qtooltip.h>
#include <qtimer.h>
#include <qclipboard.h>


extern KviPtrList<KviHelpWindow> * g_pHelpWindowList;
extern KviPtrList<KviHelpWidget> * g_pHelpWidgetList;

KviHelpWidget::KviHelpWidget(QWidget * par,KviFrame * lpFrm,bool bIsStandalone)
: QWidget(par,"help_widget")
{

	if(bIsStandalone)g_pHelpWidgetList->append(this);
	m_bIsStandalone = bIsStandalone;

//#warning "Re enable this when using Qt 3.0 : QProcess "
//	m_pSearchJob = 0;
	m_pTextBrowser = new QTextBrowser(this,"text_browser");
	m_pTextBrowser->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_pTextBrowser->setFocusPolicy(QWidget::NoFocus);
	m_pToolBar = new QHBox(this,"help_tool_bar");

	m_pBtnIndex = new QToolButton(m_pToolBar);
	m_pBtnIndex->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPINDEX));
	connect(m_pBtnIndex,SIGNAL(clicked()),this,SLOT(showIndex()));
	m_pBtnIndex->setUsesBigPixmap(true);

	m_pBtnBackward = new QToolButton(m_pToolBar);
	m_pBtnBackward->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPBACKWARD));
	connect(m_pBtnBackward,SIGNAL(clicked()),m_pTextBrowser,SLOT(backward()));
	m_pBtnBackward->setEnabled(false);
	m_pBtnBackward->setUsesBigPixmap(true);

	m_pBtnForward = new QToolButton(m_pToolBar);
	m_pBtnForward->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPFORWARD));
	connect(m_pBtnForward,SIGNAL(clicked()),m_pTextBrowser,SLOT(forward()));
	m_pBtnForward->setEnabled(false);
	m_pBtnForward->setUsesBigPixmap(true);

	if(bIsStandalone)
	{
		QToolButton * b = new QToolButton(m_pToolBar);
		b->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPCLOSE));
		connect(b,SIGNAL(clicked()),this,SLOT(doClose()));
		b->setUsesBigPixmap(true);
	}

	m_pBtnSearch = new QToolButton(m_pToolBar);
	m_pBtnSearch->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPSEARCH));
	connect(m_pBtnSearch,SIGNAL(clicked()),this,SLOT(doSearch()));
	m_pBtnSearch->setUsesBigPixmap(true);
//#warning "Re-enable this button when using Qt 3.0 : QProcess"
	m_pBtnSearch->setEnabled(false);

	m_pSearchInput = new QLineEdit(m_pToolBar);
	QToolTip::add(m_pSearchInput,__tr("Search keywords"));
//#warning "Re connect this signal when using Qt 3.0 : QProcess"
//	connect(m_pSearchInput,SIGNAL(returnPressed()),this,SLOT(doSearch()));
	
	m_pToolBar->setStretchFactor(m_pSearchInput,1);
	connect(m_pTextBrowser,SIGNAL(backwardAvailable(bool)),m_pBtnBackward,SLOT(setEnabled(bool)));
	connect(m_pTextBrowser,SIGNAL(forwardAvailable(bool)),m_pBtnForward,SLOT(setEnabled(bool)));

	m_pTextBrowser->viewport()->installEventFilter(this);
}

KviHelpWidget::~KviHelpWidget()
{
	if(m_bIsStandalone)g_pHelpWidgetList->removeRef(this);

//	if(m_pSearchJob)delete m_pSearchJob;
}

void KviHelpWidget::showIndex()
{
	m_pTextBrowser->setSource("index.html");
}

void KviHelpWidget::doSearch()
{
	setCursor(waitCursor);
	m_pTextBrowser->setCursor(waitCursor);
	m_pTextBrowser->viewport()->setCursor(waitCursor);
	m_pSearchInput->setCursor(waitCursor);

	KviStr str=m_pSearchInput->text();
	str.stripWhiteSpace();
	if(str.hasData())doExactSearchFor(str.ptr());
}

void KviHelpWidget::doExactSearchFor(const char * keys)
{
//#warning "Search must be reimplemented with QProcess!"
/*	if(m_pSearchJob)delete m_pSearchJob;
	m_pSearchJob = new KviProcess();
	connect(m_pSearchJob,SIGNAL(terminated(KviProcess *,int)),this,SLOT(searchJobTerminated(KviProcess *,int)));

	KviStr filesToSearch;
	g_pApp->getGlobalKvircDirectory(filesToSearch,KviApp::Help);
	KviStr fileToProduce;
	g_pApp->getLocalKvircDirectory(fileToProduce,KviApp::Help,"last_search_result.html");

	KviStr tmp;
#warning "directory where the script is located...!"
	tmp.sprintf("kvi_search_help.sh %s %s %s",filesToSearch.ptr(),fileToProduce.ptr(),keys);
	if(!m_pSearchJob->run(tmp.ptr(),false,true,true)){
		delete m_pSearchJob;
		m_pSearchJob = 0;
		kvi_warningBox(__tr("Could not execute command\n%s"),tmp.ptr());
	} else m_pBtnSearch->setEnabled(false);
*/
}
/*
void KviHelpWidget::searchJobTerminated(KviProcess *,int)
{

	setCursor(arrowCursor);
	m_pTextBrowser->setCursor(arrowCursor);
	m_pTextBrowser->viewport()->setCursor(arrowCursor);
	m_pSearchInput->setCursor(arrowCursor);

	delete m_pSearchJob;
	m_pSearchJob = 0;
	showIndex(); //HACK HACK HACK
	KviStr fileToProduce;
	g_pApp->getLocalKvircDirectory(fileToProduce,KviApp::Help,"last_search_result.html");
	m_pTextBrowser->setSource(fileToProduce.ptr());
	m_pBtnSearch->setEnabled(true);

}
*/
void KviHelpWidget::resizeEvent(QResizeEvent *e)
{
	int hght = m_pToolBar->sizeHint().height();
	if(hght < 40)hght = 40;
	m_pToolBar->setGeometry(0,0,width(),hght);
	m_pTextBrowser->setGeometry(0,hght,width(),height() - hght);
}

void KviHelpWidget::doClose()
{
	// hack needed to workaround "QToolBar::emulateButtonClicked()"
	// that refers to the "this" pointer after this slot has been
	// called (from the "too-small-toolbar-for-all-items-popup")
	QTimer::singleShot(0,this,SLOT(suicide()));
}

void KviHelpWidget::suicide()
{
	// goodbye cruel wolrd
	delete this;
}

QSize KviHelpWidget::sizeHint() const
{
	int wdth = m_pTextBrowser->sizeHint().width();
	if(m_pToolBar->sizeHint().width() > wdth)wdth = m_pToolBar->sizeHint().width();
	QSize s(wdth,m_pTextBrowser->sizeHint().height() + m_pToolBar->sizeHint().height());
	return s;
}

bool KviHelpWidget::eventFilter(QObject * o, QEvent *e)
{
	QClipboard *cb = QApplication::clipboard();
	
	if(e->type() == QEvent::MouseButtonRelease) {
		if(m_pTextBrowser->hasSelectedText()) {
			cb->setText(m_pTextBrowser->selectedText());
		}
	}

	return QWidget::eventFilter(o,e);
}

#include "helpwidget.moc"
