#ifndef _GNUTELLAWINDOW_H_
#define _GNUTELLAWINDOW_H_
//
//   File : gnutellawindow.h
//   Creation date : Mon Apr 16 2001 05:22:00 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_string.h"

#include "kvi_list.h"
#include <qlistview.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>

class QSplitter;
class KviThemedLabel;
class KviGnutellaThread;
class KviGnutellaWindow;
class KviGnutellaHitThreadEvent;
class KviThreadEvent;
class KviDns;

//typedef struct _KviGnutellaHit KviGnutellaHit;



class KviGnutellaNodeItem : public QListViewItem
{
	friend class KviGnutellaWindow;
protected:
	KviGnutellaNodeItem(QListView * par,int id,KviStr szDescription,KviStr szIp,KviStr szPort);
	~KviGnutellaNodeItem();
protected:
	int m_iNodeId;
	bool m_bOnNetwork;
public:
	int id(){ return m_iNodeId; };
	void setStatus(const char * stat);
	void setBandwidthStats(const char * stat);
	bool onNetwork(){ return m_bOnNetwork; };
	void setOnNetwork(){ m_bOnNetwork = true; };
};


// gnutellasearch.h
typedef struct _KviGnutellaQueryHitInfo KviGnutellaQueryHitInfo;


class KviGnutellaTransferTab;
class KviGnutellaSearchTab;


class KviGnutellaWindow : public KviWindow
{
	Q_OBJECT
public:
	KviGnutellaWindow(KviFrame * lpFrm);
	~KviGnutellaWindow();
protected:
	QSplitter         * m_pTopSplitter;
	QSplitter         * m_pVertSplitter;
	KviThemedLabel    * m_pStatusLabel;
	KviThemedLabel    * m_pNetworkBandwidthLabel;

	// Network tab

	QSplitter         * m_pNetworkSplitter; // <-- don't need this pointer
	QListView         * m_pNetworkView;
	QListView         * m_pHostList;
	QLineEdit         * m_pHostInput;
	QPushButton       * m_pAddHostButton;
	QPushButton       * m_pConnectToSelectedButton;
	QPushButton       * m_pRemoveConnectionsButton;
	QToolButton       * m_pOptionsButton;

	// Search tab
	QPopupMenu        * m_pHostCachePopup;

	// Shared files tab

	QListView         * m_pSharedFilesList;
	QPushButton       * m_pRemoveSelectedFilesButton;
	QLabel            * m_pSharedFilesCountLabel;

	KviGnutellaSearchTab        * m_pSearchTab;
	KviGnutellaTransferTab      * m_pTransferTab;

	KviGnutellaThread * m_pGnutellaThread;

	int                 m_iConnectedNodes;

	KviPtrList<KviDns>         * m_pDnsList;

protected:
	virtual QPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
	virtual void applyOptions();
	KviGnutellaNodeItem * findNodeItem(int id);
	void updateStatusLabel();
	void enableSearchButton();
	void handleEvent(KviThreadEvent *e);
	void updateSharedFilesCount();
	void fillSharedFilesList();
	void addHostToList(KviStr &buf);
	void addHostToList(const char * host,const char *port);
public:
	int connectedNodes(){ return m_iConnectedNodes; };
	KviGnutellaThread * mainGnutellaThread(){ return m_pGnutellaThread; };
	bool connectTo(const char * szIp,const char * szPort);
	void triggerUpdateOptions();
	void startDownload(KviGnutellaQueryHitInfo * inf);
	KviGnutellaQueryHitInfo * findBestQueryHit(const char * fileName,unsigned int uSize,KviPtrList<KviStr> * excludeHosts);
	virtual QSize sizeHint() const;
	virtual bool event(QEvent *e);
protected slots:
	void showOptionsDialog();
	void hostInputTextChanged(const QString &text);
	void networkViewDoubleClicked(QListViewItem * it);
	void addHostClicked();
	void hostListSelectionChanged();
	void connectToSelectedClicked();
	void removeSelectedConnections();
	void networkViewSelectionChanged();
	void removeNonConnectedNodes();
	void acceptConnectionsToggled(bool bChecked);
	void autoConnectToggled(bool bChecked);
	void removeSelectedFilesClicked();
	void sharedFilesSelectionChanged();
	void enableFileSharingToggled(bool bChecked);
	void spyLocalSearchResultsToggled(bool bChecked);
	void addSharedFiles();
	void connectToHostcache(int id);
	void hostLookupDone(KviDns * dns);

};

#ifndef _LIBKVIGNUTELLA_CPP_
	extern KviGnutellaWindow            * g_pGnutellaWindow;
#endif

#endif //_KVI_GNUTELLAWINDOW_H_
