#ifndef _GNUTELLASHARES_H_
#define _GNUTELLASHARES_H_

//
//   File : gnutellashares.h
//   Creation date : Tue Apr 22 2001 16:01:09 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_thread.h"


typedef struct _KviGnutellaSharedFile
{
	unsigned int         uId;
	KviStr               szFileName;
	KviStr               szLowCaseFileName;
	KviStr               szPath;
	unsigned int         uFileSize;
	Q_UINT32             uCharFlags[8];
} KviGnutellaSharedFile;

typedef struct _KviGnutellaSearchQuery
{
	KviStr            szQueryString;
	unsigned int      uSourceNodeId;
	unsigned char     descriptorId[16];
} KviGnutellaSearchQuery;

typedef struct _KviGnutellaSearchResult
{
	KviStr                   szQueryString;
	unsigned int             uSourceNodeId;
	unsigned int             uResultsLen;
	unsigned char            uResultsCount;
	unsigned char          * pResultsBuffer;
	unsigned char            descriptorId[16];
} KviGnutellaSearchResult;

class KviGnutellaSearchThread : public KviSensitiveThread
{
public:
	KviGnutellaSearchThread();
	~KviGnutellaSearchThread();
protected:
	virtual void run();
	void search(KviGnutellaSearchQuery * q);
	bool processInternalEvents();
};


#ifndef _GNUTELLASHARES_CPP_
	extern void gnutella_shared_files_lock();
	extern KviGnutellaSharedFile * gnutella_add_shared_file(const char * szFileNameAndPath);
	extern void gnutella_remove_shared_file(unsigned int uId);
	extern KviGnutellaSharedFile * gnutella_find_shared_file(unsigned int uId);
	extern void gnutella_shared_files_unlock();
#endif


#endif // _GNUTELLASHARES_H_
