#ifndef _GNUTELLASEARCH_H_
#define _GNUTELLASEARCH_H_
//
//   File : gnutellasearch.h
//   Creation date : Sat Sep  8 01:24:46 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qwidget.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include "kvi_list.h"
#include <qcombobox.h>

#include "kvi_string.h"

// structure that keeps the complete data about a query hit
typedef struct _KviGnutellaQueryHitInfo
{
	KviStr             szName;
	KviStr             szIp;
	KviStr             szExtraInfo;
	unsigned short int uPort;
	unsigned char      servId[16];
	unsigned int       uSpeed;
	unsigned int       uIndex;
	unsigned int       uSize;
	int                iNodeId;
} KviGnutellaQueryHitInfo;

// struct declared in gnutellathread.h
typedef struct _KviGnutellaHit KviGnutellaHit;

class KviGnutellaHitThreadEvent;



class KviGnutellaHitItem : public QListViewItem
{
	friend class KviGnutellaSearchTab;
	friend class KviGnutellaWindow; // WARNING: remove this "friend"
protected:
	KviGnutellaHitItem(QListView * par,KviGnutellaQueryHitInfo * inf);
public:
	~KviGnutellaHitItem();
public:
	KviGnutellaQueryHitInfo * m_pInfo;
public:
	virtual QString key(int col,bool) const;
};

class KviConfig;

class KviGnutellaWindow;

class KviGnutellaSearchTab : public QWidget
{
	Q_OBJECT
public:
	KviGnutellaSearchTab(QWidget * par,KviGnutellaWindow * wnd);
	~KviGnutellaSearchTab();
protected:
	KviGnutellaWindow * m_pGnutellaWindow;
	QListView         * m_pListView;

	QLabel            * m_pInfoLabel;
	QCheckBox         * m_pLockCheck;

	QPushButton       * m_pClearAll;
	QPushButton       * m_pClearSelected;
	QPushButton       * m_pDownloadSelected;

//	QLineEdit         * m_pSearchString;
	QComboBox         * m_pSearchString;
	QLineEdit         * m_pSearchMinSpeed;
	QPushButton       * m_pSearchButton;

	QPushButton       * m_pSaveAllButton;
	QPushButton       * m_pSaveSelectedButton;
	QPushButton       * m_pLoadButton;

	QLineEdit         * m_pRegExpEdit;
	QPushButton       * m_pApplyFilterButton;

	KviPtrList<KviGnutellaQueryHitInfo> * m_pPendingHits;
public:
	void addQueryHit(KviGnutellaHit * h,KviGnutellaHitThreadEvent *e);
	KviGnutellaQueryHitInfo * findBestQueryHit(const char * fileName,unsigned int uSize,KviPtrList<KviStr> * excludeHosts);
public slots:
	void updateSearchButtonState(const QString &);
protected slots:
	void applyFilter();
	void saveHitList();
	void clearDuplicates();
	void saveSelectedHitList();
	void loadHitList();
	void searchResultDoubleClicked(QListViewItem *);
	void listViewSelectionChanged();
	void doSearch();
	void clearAll();
	void clearSelected();
	void downloadSelected();
	void lockToggled(bool bChecked);
	void searchStringActivated(const QString &);
protected:
	void doSearchString(const QString &str);
	void addQueryHit(KviGnutellaQueryHitInfo * info);
	KviGnutellaQueryHitInfo * getHit(KviConfig * cfg,int idx);
	void putHit(KviConfig * cfg,KviGnutellaHitItem * it,int idx);
	void saveHitListToFile(bool bSelectedOnly);
	KviGnutellaQueryHitInfo * allocQueryHitInfo(KviGnutellaHit * h,KviGnutellaHitThreadEvent *e);
	void updateInfoLabel();
};



#endif //_GNUTELLASEARCH_H_
