#ifndef _GNUTELLAPROTO_H_
#define _GNUTELLAPROTO_H_
//
//   File : gnutellaproto.h
//   Creation date : Mon Apr 23 2001 13:24:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_bswap.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////
// gnutella byte order looks to be messed
// every client does a different thing
// the spec says all fields to be big-endian (unless otherwise noted)
// but gtk_gnutella seems to the completly the opposite of the specification
// and in fact, the data in the packet usually do NOT need to be swapped on an Intel/AMD
///////////////////////////////////////////////////////////////////////////////////////////////////////////


#ifdef BIG_ENDIAN_MACHINE_BYTE_ORDER

	#define hToGnutellaL(__x) kvi_swap32(__x)
	#define gnutellaToHL(__x) kvi_swap32(__x)
	#define hToGnutellaS(__x) kvi_swap16(__x)
	#define gnutellaToHS(__x) kvi_swap16(__x)

	#define hToGnutellaReversedL(__x) __x
	#define gnutellaReversedToHL(__x) __x

#else

	#define hToGnutellaL(__x) __x
	#define gnutellaToHL(__x) __x
	#define hToGnutellaS(__x) __x
	#define gnutellaToHS(__x) __x

	#define hToGnutellaReversedL(__x) kvi_swap32(__x)
	#define gnutellaReversedToHL(__x) kvi_swap32(__x)

#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////
// Data packet format and related structure
///////////////////////////////////////////////////////////////////////////////////////////////////////////


// DESCRIPTOR: 23 bytes
//       [ descriptorId:16 ][ payloadDescriptor:1 ][ TTL:1 ][ hops:1 ][ payloadLength:4 ]

#define GNUTELLA_DESCRIPTOR_SIZE 23

class KviGnutellaNode;

typedef struct _KviGnutellaDescriptor
{
	KviGnutellaNode * pSourceNode;         // source node of the packet

	unsigned char *   pData;               // 16 bytes of descriptorId, in fact a pointer to the whole data
	unsigned int      uPayloadLength;      // length of the payload
	unsigned char     uPayloadDescriptor;  // type of the descriptor
	unsigned char     uTtl;                // time to live
	unsigned char     uHops;               // hops
	unsigned char *   pPayload;            // pointer to the payload
} KviGnutellaDescriptor;

///////////////////////////////////////////////////////////////////////////////////////////////////////////
// Payload descriptors
///////////////////////////////////////////////////////////////////////////////////////////////////////////


// PING: Payload = 0 bytes
#define GNUTELLA_PING      0x00

// PONG: Payload = 14 bytes
//        [ port:2 ][ ip:4 ][[ shared_files:4 ][ shared_bytes:4 ]
#define GNUTELLA_PONG      0x01

// PUSH: Payload = 26 bytes
//        [ serventId:16 ][ file_index:4 ][ ip_address:4 ][ port:2 ]
#define GNUTELLA_PUSH      0x40

// QUERY: Payload = 2 + (n+1) bytes
//        [ minSpeed:2 ][ search_string:n + 1 ]
#define GNUTELLA_QUERY     0x80

// QUERYHIT: Payload = 11 + n + 16
//        [ number_of_hits:1 ][ port:2 ][ ipaddress:4 ][ speed:4 ][ results:n ][ serventId:16 ]
//        results: number_of_hits * [ file_index:4 ][ file_size:4 ][ file_name:m + 2 ]
#define GNUTELLA_QUERYHIT  0x81




#endif //_GNUTELLAPROTO_H_
