#ifndef _GNUTELLAOPTIONS_H_
#define _GNUTELLAOPTIONS_H_
//
//   File : gnutellaoptions.h
//   Creation date : Tue Apr 24 2001 15:43:59 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_thread.h"

#include <qstringlist.h>

#include <qdialog.h>


class KviGnutellaOptions
{
public:
	KviGnutellaOptions();
	~KviGnutellaOptions();
public:
	bool                 m_bAcceptConnections;                      // internal
	bool                 m_bDoListen;                               // network
	unsigned short int   m_uListenPort;                             // network

	unsigned int         m_uMinConnections;                         // network
	unsigned int         m_uMaxConnections;                         // network

	unsigned int         m_uMaxUploads;                             // sharing
	bool                 m_bAutoConnectToReachMinConnections;       // internal

	bool                 m_bEnableFileSharing;                      // internal
	unsigned short int   m_uTransferListenPort;                     // sharing

	KviStr               m_szDownloadDirectory;                     // sharing
	KviStr               m_szIncompleteDirectory;                   // sharing

	unsigned short int   m_uConnectionSpeed;                        // sharing

	QStringList          m_cacheHosts;                              // internal

	unsigned int         m_uNetworkConnectTimeoutInMSecs;           // network
	unsigned int         m_uNetworkHandshakeTimeoutInMSecs;         // network

	unsigned short int   m_uDefaultTtl;                             // network

	bool                 m_bSpyLocalSearchResults;                  // internal

	unsigned short int   m_uMaxNetworkConnectionsToDropPerDownload; // sharing
	bool                 m_bDropNetworkConnectionsWhenDownloading;  // sharing

	// stalled is a transfer that has a rate under m_uStallTransferRate for more than m_uStallTimeout msecs
	bool                 m_bKillStalledDownloadTransfers;
	bool                 m_bKillStalledUploadTransfers;

	unsigned int         m_uStallTransferRate;
	unsigned int         m_uStallTimeoutInMSecs;

	unsigned int         m_uMaxSameHostRetries;
	bool                 m_bAutoRetryFailedTransfers;

	bool                 m_bTryGnutella04After06Failure;
public:
	void load();
	void save();
};

class KviOptionsWidget;

class KviGnutellaOptionsDialog : public QDialog
{
	Q_OBJECT
public:
	KviGnutellaOptionsDialog();
	~KviGnutellaOptionsDialog();
protected:
	KviOptionsWidget * m_pNetworkOptions;
	KviOptionsWidget * m_pSharingOptions;

protected slots:
	void okClicked();
	void cancelClicked();
};

#ifndef _LIBKVIGNUTELLA_CPP_
	extern KviMutex                     * g_pGnutellaOptionsMutex;
	extern KviGnutellaOptions           * g_pGnutellaOptions;
#endif

#endif //_GNUTELLAOPTIONS_H_
