//
//   File : gnutellaoptions.cpp
//   Creation date : Tue Apr 24 2001 15:51:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _GNUTELLAOPTIONS_CPP_

#include "gnutellaoptions.h"
#include "gnutellawindow.h"

#include "kvi_app.h"
#include "kvi_config.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"

#include "kvi_optionswidget.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <qtabwidget.h>

extern KviGnutellaOptionsDialog * g_pGnutellaOptionsDialog;
extern KviMutex                 * g_pGnutellaOptionsMutex;
extern KviGnutellaOptions       * g_pGnutellaOptions;
extern KviGnutellaWindow        * g_pGnutellaWindow;

KviGnutellaOptions::KviGnutellaOptions()
{
}

KviGnutellaOptions::~KviGnutellaOptions()
{
}

void KviGnutellaOptions::save()
{
	KviStr buf;

	g_pApp->getLocalKvircDirectory(buf,KviApp::ConfigPlugins,"libkvignutella.conf");

	KviConfig cfg(buf.ptr());

	cfg.writeEntry("uListenPort",m_uListenPort);                           //
	cfg.writeEntry("bAcceptConnections",m_bAcceptConnections);             // internal
	cfg.writeEntry("uMaxConnections",m_uMaxConnections);                   //
	cfg.writeEntry("uMinConnections",m_uMinConnections);                   //
	cfg.writeEntry("bDoListen",m_bDoListen);                               //
	cfg.writeEntry("bEnableFileSharing",m_bEnableFileSharing);             // internal
	cfg.writeEntry("uTransferListenPort",m_uTransferListenPort);           //
	cfg.writeEntry("bAutoConnectToReachMinConnections",m_bAutoConnectToReachMinConnections); // internal
	cfg.writeEntry("uConnectionSpeed",m_uConnectionSpeed);                 //
	cfg.writeEntry("szDownloadDirectory",m_szDownloadDirectory.ptr());     //
	cfg.writeEntry("szIncompleteDirectory",m_szIncompleteDirectory.ptr()); //
	cfg.writeEntry("cacheHosts",m_cacheHosts);                             // FIXME: make it selectable
	cfg.writeEntry("uNetworkConnectTimeoutInMSecs",m_uNetworkConnectTimeoutInMSecs);
	cfg.writeEntry("uNetworkHandshakeTimeoutInMSecs",m_uNetworkHandshakeTimeoutInMSecs);
	cfg.writeEntry("uDefaultTtl",m_uDefaultTtl);
	cfg.writeEntry("bSpyLocalSearchResults",m_bSpyLocalSearchResults);
	cfg.writeEntry("uMaxUploads",m_uMaxUploads);
	cfg.writeEntry("uMaxNetworkConnectionsToDropPerDownload",m_uMaxNetworkConnectionsToDropPerDownload);
	cfg.writeEntry("bDropNetworkConnectionsWhenDownloading",m_bDropNetworkConnectionsWhenDownloading);
	cfg.writeEntry("bKillStalledDownloadTransfers",m_bKillStalledDownloadTransfers);
	cfg.writeEntry("bKillStalledUploadTransfers",m_bKillStalledUploadTransfers);
	cfg.writeEntry("uStallTransferRate",m_uStallTransferRate);
	cfg.writeEntry("uStallTimeoutInMSecs",m_uStallTimeoutInMSecs);
	cfg.writeEntry("uMaxSameHostRetries",m_uMaxSameHostRetries);
	cfg.writeEntry("bAutoRetryFailedTransfers",m_bAutoRetryFailedTransfers);
	cfg.writeEntry("bTryGnutella04After06Failure",m_bTryGnutella04After06Failure);
}

void KviGnutellaOptions::load()
{
	KviStr buf;

	g_pApp->getLocalKvircDirectory(buf,KviApp::ConfigPlugins,"libkvignutella.conf");

	KviConfig cfg(buf.ptr());

	m_bSpyLocalSearchResults            = cfg.readBoolEntry("bSpyLocalSearchResults",false);
	m_bKillStalledDownloadTransfers     = cfg.readBoolEntry("bKillStalledDownloadTransfers",true);
	m_bKillStalledUploadTransfers       = cfg.readBoolEntry("bKillStalledUploadTransfers",false);
	m_uStallTransferRate                = cfg.readUIntEntry("uStallTransferRate",0);
	m_uStallTimeoutInMSecs              = cfg.readUIntEntry("uStallTimeoutInMSecs",30000);
	m_uDefaultTtl                       = cfg.readUShortEntry("uDefaultTtl",5);
	m_uListenPort                       = cfg.readUShortEntry("uListenPort",6346);
	m_bAcceptConnections                = cfg.readBoolEntry("bAcceptConnections",true);
	m_uMaxConnections                   = cfg.readUIntEntry("uMaxConnections",7);
	m_uMinConnections                   = cfg.readUIntEntry("uMinConnections",4);
	m_bDoListen                         = cfg.readBoolEntry("bDoListen",true);
	m_bEnableFileSharing                = cfg.readBoolEntry("bEnableFileSharing",true);
	m_uTransferListenPort               = cfg.readUShortEntry("uTransferListenPort",6340);
	m_uNetworkConnectTimeoutInMSecs     = cfg.readUIntEntry("uNetworkConnectTimeoutInMSecs",20000);
	m_uNetworkHandshakeTimeoutInMSecs   = cfg.readUIntEntry("uNetworkHandshakeTimeoutInMSecs",30000);
	m_uMaxNetworkConnectionsToDropPerDownload = cfg.readUIntEntry("uMaxNetworkConnectionsToDropPerDownload",4);
	m_bDropNetworkConnectionsWhenDownloading = cfg.readBoolEntry("bDropNetworkConnectionsWhenDownloading",true);
	if(m_uMinConnections > m_uMaxConnections)m_uMinConnections = m_uMaxConnections;
	m_bAutoConnectToReachMinConnections = cfg.readBoolEntry("bAutoConnectToReachMinConnections",true);
	m_uConnectionSpeed                  = cfg.readUShortEntry("uConnectionSpeed",56);
	m_uMaxUploads                       = cfg.readUIntEntry("uMaxUploads",3);
	m_bAutoRetryFailedTransfers         = cfg.readBoolEntry("bAutoRetryFailedTransfers",true);
	m_uMaxSameHostRetries               = cfg.readUIntEntry("uMaxSameHostRetries",10);
	m_bTryGnutella04After06Failure      = cfg.readBoolEntry("bTryGnutella04After06Failure",true);
	KviStr tmp;
	g_pApp->getLocalKvircDirectory(tmp,KviApp::Incoming);
	m_szDownloadDirectory               = cfg.readEntry("szDownloadDirectory",tmp.ptr());
	kvi_adjustFilePath(m_szDownloadDirectory);
	tmp.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	tmp.append("incomplete");
	kvi_adjustFilePath(tmp);
	m_szIncompleteDirectory             = cfg.readEntry("szIncompleteDirectory",tmp.ptr());
	kvi_adjustFilePath(m_szIncompleteDirectory);
//#warning "Ensure that this is NOT the same dir!"
	QStringList list;
	list.append("gnutella.hostscache.com:6346");
	list.append("router.limewire.com:6346");
	list.append("gnutellahosts.com:6346");
	list.append("gnotella.fileflash.com:6346");
	list.append("connect1.gnutellanet.com:6346");
	list.append("connect2.gnutellanet.com:6346");
	list.append("connect3.gnutellanet.com:6346");
	list.append("connect4.gnutellanet.com:6346");
	list.append("gnet2.ath.cx:6346");
	list.append("public.bearshare.net:6346");

	m_cacheHosts = cfg.readStringListEntry("cacheHosts",list);
}



KviGnutellaOptionsDialog::KviGnutellaOptionsDialog()
: QDialog(0,"gnutella_options")
{
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_GNUTELLA)));
	setCaption(__tr("Gnutella options"));


	QGridLayout * g = new QGridLayout(this,1,1,0,0);
	g->setMargin(5);

	QTabWidget * tab = new QTabWidget(this);

	g->addMultiCellWidget(tab,0,0,0,2);

	m_pNetworkOptions = new KviOptionsWidget(tab,"gnutella_network_options_widget");

	m_pNetworkOptions->createLayout(8,1);

	g_pGnutellaOptionsMutex->lock();

	m_pNetworkOptions->addUIntSelector(0,0,0,0,__tr("Minimum network connections"),
		&(g_pGnutellaOptions->m_uMinConnections),1,1000,4,true);

	m_pNetworkOptions->addUIntSelector(0,1,0,1,__tr("Maximum network connections"),
		&(g_pGnutellaOptions->m_uMaxConnections),1,1000,7,true);

	m_pNetworkOptions->addBoolSelector(0,2,0,2,__tr("Listen for network connections"),
		&(g_pGnutellaOptions->m_bDoListen),true);

	m_pNetworkOptions->addUShortIntSelector(0,3,0,3,__tr("Network listen port"),
		&(g_pGnutellaOptions->m_uListenPort),1,65535,6346,true);

	m_pNetworkOptions->addUIntSelector(0,4,0,4,__tr("Connect timeout (in msecs)"),
		&(g_pGnutellaOptions->m_uNetworkConnectTimeoutInMSecs),1,65535,30,true);

	m_pNetworkOptions->addUIntSelector(0,5,0,5,__tr("Handshake timeout (in msecs)"),
		&(g_pGnutellaOptions->m_uNetworkHandshakeTimeoutInMSecs),1,65535,30,true);

	m_pNetworkOptions->addUShortIntSelector(0,6,0,6,__tr("Default TTL"),
		&(g_pGnutellaOptions->m_uDefaultTtl),1,50,5,true);

	m_pNetworkOptions->addRowSpacer(0,7,0,7);

	g_pGnutellaOptionsMutex->unlock();

	//m_pNetworkOptions->layout()->setColStretch(0,1);


	tab->addTab(m_pNetworkOptions,__c2q(__tr("Network")));

	m_pSharingOptions = new KviOptionsWidget(tab,"gnutella_sharing_options_widget");

	m_pSharingOptions->createLayout(9,1);

	m_pSharingOptions->addUShortIntSelector(0,0,0,0,__tr("Connection speed (KBit/sec)"),
		&(g_pGnutellaOptions->m_uConnectionSpeed),1,65535,33,true);

	m_pSharingOptions->addUShortIntSelector(0,1,0,1,__tr("Transfer listen port"),
		&(g_pGnutellaOptions->m_uTransferListenPort),1,65535,6340,true);

	m_pSharingOptions->addUIntSelector(0,2,0,2,__tr("Max uploads"),
		&(g_pGnutellaOptions->m_uMaxUploads),1,65535,2,true);

	m_pSharingOptions->addBoolSelector(0,3,0,3,__tr("Drop network connections when downloading"),
		&(g_pGnutellaOptions->m_bDropNetworkConnectionsWhenDownloading),true);

	m_pSharingOptions->addUShortIntSelector(0,4,0,4,__tr("Max network connections to drop per download"),
		&(g_pGnutellaOptions->m_uMaxNetworkConnectionsToDropPerDownload),0,65535,4,true);

	m_pSharingOptions->addSeparator(0,5,0,5);

	m_pSharingOptions->addDirectorySelector(0,6,0,6,__tr("Incomplete directory"),
		&(g_pGnutellaOptions->m_szIncompleteDirectory),true);

	m_pSharingOptions->addDirectorySelector(0,7,0,7,__tr("Download directory"),
		&(g_pGnutellaOptions->m_szDownloadDirectory),true);

	m_pSharingOptions->addRowSpacer(0,8,0,8);

	tab->addTab(m_pSharingOptions,__tr("Sharing"));

	QPushButton * b = new QPushButton(__c2q(__tr("Cancel")),this);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	g->addWidget(b,1,1);

	b = new QPushButton(__tr("Ok"),this);
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	g->addWidget(b,1,2);

	g->setColStretch(0,1);

}

KviGnutellaOptionsDialog::~KviGnutellaOptionsDialog()
{
	g_pGnutellaOptionsDialog = 0;
}


void KviGnutellaOptionsDialog::okClicked()
{
	g_pGnutellaOptionsMutex->lock();
	m_pNetworkOptions->commit();
	m_pSharingOptions->commit();
	g_pGnutellaOptionsMutex->unlock();
	if(g_pGnutellaWindow)g_pGnutellaWindow->triggerUpdateOptions();
	delete this;
}

void KviGnutellaOptionsDialog::cancelClicked()
{
	delete this;
}


#include "m_gnutellaoptions.moc"
