#ifndef _GNUTELLANODE_H_
#define _GNUTELLANODE_H_
//
//   File : gnutellanode.h
//   Creation date : Tue Apr 17 2001 21:17:21 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_socket.h"

#include "kvi_time.h"

class KviGnutellaThread;

typedef struct _KviGnutellaNodeStats
{
	unsigned long int  uTotalPacketsReceived;      // packets processed
	unsigned long int  uTotalPacketsSent;          // packets enqueued
	unsigned long int  uTotalBytesReceived;        // bytes effectively received
	unsigned long int  uTotalBytesSent;            // bytes effectively delivered
//	unsigned long int  uTotalDuplicatedPackets;    // packets dropped because duplicated (already routed)
	unsigned long int  uTotalUnknownPackets;       // unrecognized packets
//	unsigned long int  uTotalUnroutablePackets;    // packets with no return path (calculated now)

	unsigned long int  uTotalPings;                // total ping packets that we have received
	unsigned long int  uTotalPingsLoopedBack;      // the pings that were looped-back (thus dropped)
	unsigned long int  uTotalPingsTtlExpired;      // the pings that had ttl expired (thus dropped)
	unsigned long int  uTotalPingsDuplicated;      // the pings that have been duplicated (thus dropped)
//	unsigned long int  uTotalPingsRouted;          // the pings that have been succesfully routed

	unsigned long int  uTotalPongs;                // total pong packet that we have received
	unsigned long int  uTotalPongsDirectedToMe;    // the pong packets that are directed to me
	unsigned long int  uTotalPongsTtlExpired;      // the pongs that had ttl expired (thus dropped)
	unsigned long int  uTotalPongsUnroutable;      // the pongs that had no return path (thus dropped)
//	unsigned long int  uTotalPongsRouted;          // the pongs that have been succesfully routed

	unsigned long int  uTotalQueries;              // total query packets received
	unsigned long int  uTotalQueriesLoopedBack;    // the queries that were looped-back (thus dropped)
	unsigned long int  uTotalQueriesTtlExpired;    // the queries that had ttl expired (thus dropped)
	unsigned long int  uTotalQueriesDuplicated;    // the queries duplicated (thus dropped)
//	unsigned long int  uTotalQueriesRouted;        // the queries that have been succesfully routed

	unsigned long int  uTotalQueryHits;
	unsigned long int  uTotalQueryHitsDirectedToMe;
	unsigned long int  uTotalQueryHitsTtlExpired;
	unsigned long int  uTotalQueryHitsUnroutable;
//	unsigned long int  uTotalQueryHitsRouted;

	unsigned long int  uTotalPushes;
	unsigned long int  uTotalPushesDirectedToMe;
	unsigned long int  uTotalPushesTtlExpired;
	unsigned long int  uTotalPushesDuplicated;
	unsigned long int  uTotalPushesUnroutable;
//	unsigned long int  uTotalPushesRouted;
} KviGnutellaNodeStats;

class KviGnutellaNode
{
	friend class KviGnutellaThread;
public:
	enum ConnectionType  { Incoming , Outgoing };
	enum State { JustBorn , Connecting , Handshake , Connected , Dead };
	enum Protocol { Unknown , Gnutella04 , Gnutella06 };
protected:
	KviGnutellaNode(const char * szIp,unsigned short int uPort,ConnectionType t,Protocol p);
public:
	~KviGnutellaNode();
protected:
	State              m_state;
	ConnectionType     m_connectionType;
	int                m_iId;
	KviStr             m_szIp;
	unsigned short int m_uPort;
	kvi_socket_t       m_sock;
	unsigned char    * m_incomingDataBuffer;  // incoming data buffer
	int                m_iIncomingDataLen;    // incoming data buffer length
	unsigned char    * m_outgoingDataBuffer;
	int                m_iOutgoingDataLen;
	KviStr             m_szDeathReason;
	KviStr             m_szPublicHeaders;
	Protocol           m_protocol;

	struct timeval     m_operationStartTime;

	unsigned long int  m_uLastBandwidthSentBytes;
	unsigned long int  m_uLastBandwidthRecvBytes;

	KviGnutellaNodeStats m_stats;

public:
	void resetBandwidthStats();
	int curBandwidthSentBytes(){ return m_stats.uTotalBytesSent - m_uLastBandwidthSentBytes; };
	int curBandwidthRecvBytes(){ return m_stats.uTotalBytesReceived - m_uLastBandwidthRecvBytes; };

	const char * ip(){ return m_szIp.ptr(); };
	unsigned short int port(){ return m_uPort; };

	KviGnutellaNode::State state(){ return m_state; };
	KviGnutellaNode::ConnectionType connectionType(){ return m_connectionType; };
	KviGnutellaNode::Protocol protocol(){ return m_protocol; };
	kvi_socket_t sock(){ return m_sock; };
	//time_t statsStartTime(){ return m_operationStartTime; };
	bool connect();
	bool readData();
	bool flushQueue();
	const char * publicHeaders(){ return m_szPublicHeaders; };
	void appendPublicHeaders(const char * hdr){ m_szPublicHeaders.append(hdr); };
	void setProtocol(KviGnutellaNode::Protocol p){ m_protocol = p; };
	void setConnectedFd(kvi_socket_t fd);
	void die(const char * reason);
	const char * deathReason(){ return m_szDeathReason.ptr(); };
	bool isDead(){ return m_state == Dead; };
	bool isConnected(){ return m_state == Connected; };
	bool isHandshaking(){ return m_state == Handshake; };
	int id(){ return m_iId; };
	void youAreHandshaking();
	void youAreConnected(KviGnutellaNode::Protocol p,const char * publicHeaders = 0);
	int incomingDataLength(){ return m_iIncomingDataLen; };
	unsigned char * incomingData(){ return m_incomingDataBuffer; };
	void eatIncomingData(int len);
	void appendOutgoingData(const unsigned char * buffer,int len);
	unsigned char * allocOutgoingBuffer(int len);
	int msecondsSinceOperationStart(struct timeval * now);
	void startOperation();
};

#endif //_KVI_GNUTELLANODE_H_
