#ifndef _GNUTELLADCACHE_H_
#define _GNUTELLADCACHE_H_
//
//   File : gnutelladcache.h
//   Creation date : Mon Apr 23 2001 14:00:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the gnutellas of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_list.h"

class KviGnutellaNode;

typedef struct _KviGnutellaCachedDescriptor
{
	KviGnutellaNode * pSourceNode;
	unsigned char     descriptorId[16];
} KviGnutellaCachedDescriptor;


//#define KVI_GNUTELLA_DESCRIPTOR_CACHE_HASH_ENTRIES 256
//#define KVI_GNUTELLA_DESCRIPTOR_CACHE_HASH_BITS 255
//#define KVI_GNUTELLA_DESCRIPTOR_CACHE_MAX_ENTRIES_PER_LIST 16
// 
// 1024 + (256 * (32 + (16 * 28))) = 123904 bytes

#define KVI_GNUTELLA_DESCRIPTOR_CACHE_HASH_ENTRIES 64
#define KVI_GNUTELLA_DESCRIPTOR_CACHE_HASH_BITS 63
#define KVI_GNUTELLA_DESCRIPTOR_CACHE_MAX_ENTRIES_PER_LIST 16

// quick size analyzis
// in full operation mode the cache size in memory is:
//   cache_overhead + (64 entries * (list_overhead + (16 * (node_overhead + sizeof(KviGnutellaCachedDescriptor)))))
//   thus: cache_overhead + ( 64 * (list_overhead + (16 * (node_overhead + 20))))
//     assuming the list_overhead as 32 bytes
//     assuming the node_overhead as 8 (next and prev pointer (this is a lower bound))
//     assuming the cache overhead as 64 * 4 = 256 bytes
//   we have:
//      256 + (64 * (32 + (16 * 28))) = 30976
// so finally a cache can live in more or less 31 KB, and can contain 1024 entries

class KviGnutellaDescriptorCache
{
public:
	KviGnutellaDescriptorCache();
	~KviGnutellaDescriptorCache();
public:
	KviPtrList<KviGnutellaCachedDescriptor> * m_pList[KVI_GNUTELLA_DESCRIPTOR_CACHE_HASH_ENTRIES];
public:
	void cache(unsigned char * descriptorId,KviGnutellaNode * n);
	void removeAllByNode(KviGnutellaNode * n);
	KviGnutellaCachedDescriptor * find(unsigned char * descriptorId);
};

inline bool gnutella_compare_descriptor(unsigned char * d1,unsigned char * d2)
{
	if( (((Q_UINT32 *)d1)[3]) == (((Q_UINT32 *)d2)[3]) )
	{
		if( (((Q_UINT32 *)d1)[0]) == (((Q_UINT32 *)d2)[0]) )
		{
			if( (((Q_UINT32 *)d1)[2]) == (((Q_UINT32 *)d2)[2]) )
			{
				if( (((Q_UINT32 *)d1)[1]) == (((Q_UINT32 *)d2)[1]) )
				{
					return true;
				}
			}
		}
	}
	return false;
}

#endif //_GNUTELLADCACHE_H_
