#ifndef _TABLEVIEW_H_
#define _TABLEVIEW_H_
//
// This file is part of the Szymon Stefanek's Editor for X (SSEX)
// written by Szymon Stefanek.
//
// Starting from version 3.0.0, the QTableView widget is missing from the Qt library
// It used to be the base class for SSEXEditor, thus we implement the minimum part of its
// functionality.
//

#include "qframe.h"

class QScrollBar;

class SSEXTableView : public QFrame
{
    Q_OBJECT
protected:
	SSEXTableView( QWidget *parent=0, const char *name=0, WFlags f=0 );
	~SSEXTableView();
protected:
	int            m_iRows;
	int            m_iXOffset;
	int            m_iYOffset;
	int            m_iTopCell;
	short          m_iCellHeight;
	short          m_iCellWidth;
	uint           m_bCoveringCornerSquare  : 1;
	uint           m_uSbDirtyFlag        : 8;
	uint           m_bInSbUpdate         : 1;
	uint            m_uTableFlags;
	QRect           m_rectCellUpdate;
	QScrollBar    * m_pVScrollBar;
	QScrollBar    * m_pHScrollBar;
	QWidget       * m_pCornerSquare;
public:
 	virtual void show();
	void repaint(){ repaint( 0, 0, width(), height()); };
	void repaint(int x, int y, int w, int h);
	void repaint(const QRect &r, bool erase=false){ repaint( r.x(), r.y(), r.width(), r.height()); };
protected:
	int numRows() const { return m_iRows; };
	void setNumRows(int);
	int topCell() const { return m_iTopCell; };
	void setTopCell(int row );
	int xOffset() const { return m_iXOffset; };
	int yOffset() const { return m_iYOffset; };
	virtual void setOffset( int x, int y, bool updateScrBars = TRUE );
	void setXOffset( int x){ setOffset(x,m_iYOffset); };
	void setYOffset( int y){ setOffset(m_iXOffset,y); };
	int cellWidth() const { return m_iCellWidth; };
	int cellHeight() const { return m_iCellHeight; };
	void setCellWidth(int cellW);
	void setCellHeight(int cellH);
//	int totalHeight() { return m_iCellHeight * m_iRows; };
	bool rowYPos( int row, int *yPos ) const;
	void updateCell(int row);

	QRect cellUpdateRect() const { return m_rectCellUpdate; };
	QRect viewRect() const;
	int lastRowVisible() const;
	bool rowIsVisible(int row) const { return rowYPos(row,0); };

	QScrollBar *verticalScrollBar() const { return m_pVScrollBar; };
	QScrollBar *horizontalScrollBar() const { return m_pHScrollBar; };
private slots:
	void horSbValue(int);
	void horSbSliding(int);
	void verSbValue(int);
	void verSbSliding(int); 
protected:
    virtual void paintCell(QPainter *, int row) = 0;
	void paintEvent( QPaintEvent * );
	void resizeEvent( QResizeEvent * );
	int findRow( int yPos ) const;

	int minViewX() const { return frameWidth(); };
	int minViewY() const { return frameWidth(); };
	int maxViewX() const;
	int maxViewY() const;
	int viewWidth() const { return maxViewX() - minViewX() + 1; };
	int viewHeight() const { return maxViewY() - minViewY() + 1; };
	int maxYOffset() const { return maxTopCell() * m_iCellHeight; };
	int maxXOffset() const;
	int maxTopCell() const;
	int maxVisibleCells() const { return viewHeight() / m_iCellHeight; };
private:
	void coverCornerSquare( bool );
	void setHorScrollBar(bool on);
	void setVerScrollBar(bool on);
	void updateView(){ repaint( viewRect()); };
	void updateScrollBars( uint );
	void updateFrameSize();
	void doAutoScrollBars();
	void showOrHideScrollBars();
};

const uint Tbl_vScrollBar	= 0x00000001;
const uint Tbl_hScrollBar	= 0x00000002;

#endif // QTABLEVIEW_H
