#ifndef _SCRIPTEDITOR_H_
#define _SCRIPTEDITOR_H_

//
//   File : scripteditor.h
//   Creation date : Sun Mar 28 1999 16:11:48 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_scripteditor.h"

#include "editor.h"

#include <qlabel.h>
#include <qcstring.h>


class KviScriptEditorImplementation : public KviScriptEditor
{
	Q_OBJECT
public:
	KviScriptEditorImplementation(QWidget * par);
	~KviScriptEditorImplementation();
protected:
	SSEXEditor            * m_pEditor;
	QLabel                * m_pRowColLabel;
public:
	virtual void setText(const QCString &txt);
	virtual void getText(QCString &txt);
	virtual void setEnabled(bool bEnabled);
protected slots:
	void cursorPositionChanged(SSEXEditor *ed,int row,int col);
	void saveToFile();
	void loadFromFile();
};



#endif //!_SCRIPTEDITOR_H_
