//
//   File : kvi_scripteditor.cpp
//   Creation date : Sun Mar 28 1999 16:12:41 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_SCRIPTEDITOR_CPP_

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "scripteditor.h"

#include <qlayout.h>
#include <qtoolbutton.h>
#include <qlabel.h>

#include "kvi_fileutils.h"
#include "kvi_msgbox.h"
#include "kvi_locale.h"
#include "kvi_filedialog.h"

extern KviPtrList<KviScriptEditorImplementation> * g_pScriptEditorWindowList;

KviScriptEditorImplementation::KviScriptEditorImplementation(QWidget * par)
:KviScriptEditor(par)
{
	g_pScriptEditorWindowList->append(this);

	QGridLayout * g = new QGridLayout(this,2,3,0,0);

	m_pEditor = new SSEXEditor(this);
	g->addMultiCellWidget(m_pEditor,0,0,0,2);
	g->setRowStretch(0,1);
	m_pEditor->setMode(SSEXEditor::Perl);

	QToolButton * b = new QToolButton(DownArrow,this);
	g->addWidget(b,1,0);

	QPopupMenu * pop = new QPopupMenu(b);
	pop->insertItem(__tr("Save to file"),this,SLOT(saveToFile()));
	pop->insertItem(__tr("Load from file"),this,SLOT(loadFromFile()));
	b->setPopup(pop);
	b->setPopupDelay(1);

	QLabel * l = new QLabel(" ",this);
	l->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	g->setColStretch(1,1);
	g->addWidget(l,1,1);

	m_pRowColLabel = new QLabel("0",this);
	m_pRowColLabel->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	m_pRowColLabel->setMinimumWidth(80);
	g->addWidget(m_pRowColLabel,1,2);

	QObject::connect(m_pEditor,SIGNAL(cursorPositionChanged(SSEXEditor *,int,int)),this,SLOT(cursorPositionChanged(SSEXEditor *,int,int)));
}

KviScriptEditorImplementation::~KviScriptEditorImplementation()
{
	g_pScriptEditorWindowList->removeRef(this);
	m_pEditor->setModified(false);
}

void KviScriptEditorImplementation::cursorPositionChanged(SSEXEditor *ed,int row,int col)
{
	KviStr tmp(KviStr::Format,"Row:%d Col:%d",row,col);
	m_pRowColLabel->setText(tmp.ptr());
}


void KviScriptEditorImplementation::setEnabled(bool bEnabled)
{
	QWidget::setEnabled(bEnabled);
	m_pEditor->setEnabled(bEnabled);
	m_pRowColLabel->setEnabled(bEnabled);
}

void KviScriptEditorImplementation::saveToFile()
{
	KviStr fName;
	if(KviFileDialog::askForSaveFileName(fName,__tr("Choose a file name for the script"),0,__tr("KVIrc scripts (*.kvs);;All files (*)"),false,true))
	{
		QCString tmp;
		m_pEditor->getText(tmp);

		KviStr buffer = tmp.data();
		if(!kvi_writeFile(fName.ptr(),buffer))kvi_warningBox(__tr("Save failed!\nCant open the file %s for writing"),fName.ptr());
	}
}

void KviScriptEditorImplementation::setText(const QCString &txt)
{
	m_pEditor->setText(txt);
}

void KviScriptEditorImplementation::getText(QCString &txt)
{
	m_pEditor->getText(txt);
}

void KviScriptEditorImplementation::loadFromFile()
{
	KviStr fName;
	if(KviFileDialog::askForOpenFileName(fName,__tr("Choose a script file to load"),0,__tr("KVIrc scripts (*.kvs);;All files (*)")))
	{
		KviStr buffer;
		if(kvi_loadFile(fName.ptr(),buffer))setText(buffer.ptr());
		else kvi_warningBox(__tr("Failed to open the file %s"),fName.ptr());
	}
}



#include "m_scripteditor.moc"
