//
//   File : libkvieditor.cpp
//   Creation date : Mon Sep 11 2000 12:19:00 by Szymon Stefanek
//
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "kvi_module.h"
#include "kvi_uparser.h"

#include "scripteditor.h"
#include "editorwindow.h"



#include "kvi_frame.h"
#include "kvi_window.h"
#include "kvi_locale.h"

#include <qsplitter.h>


KviPtrList<KviEditorWindow> * g_pEditorWindowList = 0;
KviPtrList<KviScriptEditorImplementation> * g_pScriptEditorWindowList = 0;


/*
	@doc: editor.open
	@type:
		command
	@title:
		editor.open
	@short:
		Opens a new text editor
	@syntax:
		editor.open [filename]
	@description:
		Creates a new text editor optionally
		loading the file [filename].[br]
		The features of the editor widget are described
		in the [module:editor]editor module documentation[/module].[br]
*/

static bool editor_module_cmd_open(KviModule *,KviCommand *c)
{
	ENTER_CONTEXT(c,"editor_module_cmd_open");

	KviStr doc;
	if(!g_pUserParser->parseCmdFinalPart(c,doc))return false;


	KviEditorWindow *w = new KviEditorWindow(c->window()->frame(),__tr("Text editor"));
	if(doc.hasData())w->editor()->loadFile(doc.ptr());
	c->window()->frame()->addWindow(w);

	return c->leaveContext();
}


static bool editor_module_init(KviModule * m)
{
	g_pEditorWindowList = new KviPtrList<KviEditorWindow>;
	g_pEditorWindowList->setAutoDelete(false);
	g_pScriptEditorWindowList = new KviPtrList<KviScriptEditorImplementation>;
	g_pScriptEditorWindowList->setAutoDelete(false);

	m->registerCommand("open",editor_module_cmd_open);
	return true;
}

static bool editor_module_cleanup(KviModule *m)
{
	while(g_pEditorWindowList->first())delete g_pEditorWindowList->first();
	delete g_pEditorWindowList;
	g_pEditorWindowList = 0;

	while(g_pScriptEditorWindowList->first())delete g_pScriptEditorWindowList->first();
	delete g_pScriptEditorWindowList;
	g_pScriptEditorWindowList = 0;

	m->unregisterMetaObject("SSEXOptionsDialog");
	m->unregisterMetaObject("KviEditorWindow");
	m->unregisterMetaObject("SSEXFindWidget");
	m->unregisterMetaObject("SSEXEditor");
	m->unregisterMetaObject("KviScriptEditorImplementation");
	m->unregisterMetaObject("SSEXTableView");
	m->unregisterMetaObject("SSEXColorEditor");
	m->unregisterMetaObject("SSEXFontEditor");
	return true;
}

static bool editor_module_can_unload(KviModule *m)
{
	return ((g_pEditorWindowList == 0) || (g_pEditorWindowList->count() == 0)) && ((g_pScriptEditorWindowList == 0) || (g_pScriptEditorWindowList->count() == 0));
}

KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info=
{
	"Editor",                                               // module name
	"1.0.0",                                                // module version
	"Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)", // author & (C)
	"Text editor extension",
	editor_module_init,
	editor_module_can_unload,
	0,
	editor_module_cleanup
};

// We want C linkage on this one: we want to be able to dlsym() it with a simple name
// FIXME: Is this portable enough ? Or is better to have a table entry ?

KVIMODULEEXPORTFUNC KviScriptEditor * editor_module_createScriptEditor(QWidget * par)
{
	return new KviScriptEditorImplementation(par);
}



/*
	@doc: editor
	@type:
		module
	@short:
		Features of the text editor window
	@title:
		The text editor module
	@body:
		The text editor module adds a simple text editor to KVIrc.
		You can open files by using the command [cmd]editor.open[/cmd].[br]
		Filename must be an absolute file path.[br]
		If no filename is specified , a "new file" will be created.[br]
		The editor has three working modes:[br]
		Normal , Cpp (for c source code , with syntax highlighting) and Html
		(with light syntax highlighting).[br]
		The plugin window has a lot of keyboard shortcuts:[br]
		Here goes the list:[br]
		CTRL+C : copy the selected text to clipboard.[br]
		CTRL+V : paste the clipboard contents to the current position in the file.[br]
		CTRL+X : copy & then remove the selection.[br]
		CTRL+M : switch mode.[br]
		CTRL+I : indent one level (only in Cpp mode).[br]
		CTRL+U : unindent one level (only in Cpp mode).[br]
		CTRL+O : comment out (only in Cpp mode).[br]
		CTRL+O+Shift : comment out (alternate) (only in Cpp mode).[br]
		CTRL+P : remove comment (only in Cpp mode).[br]
		CTRL+R : record/stop recording keystrokes.[br]
		CTRL+T : replay keystrokes.[br]
		CTRL+S : save file.[br]
		CTRL+A : save file as.[br]
		CTRL+F : show/hide the find widget.[br]
		CTRL+N : find next.[br]
		CTRL+H : find prev.[br]
		CTRL+B : find next treating the string to find as a regular expression.[br]
		CTRL+G : find prev (regular expression).[br]
		CTRL+J : replace the current selection.[br]
		CTRL+K : replace all the occurences in the file.[br]
		CTRL+L : replace all the occurences in the file (regular expression).[br]
		CTRL+Q : replace and find next.[br]
		CTRL+W : replace and find next (regular expression).[br]
		CTRL+E : replace all in selection.[br]
		CTRL+D : replace all in selection (regular expression).[br]
		[br]
		I'm currently using this widget (inserted into a separate application) in Cpp mode to develop 
		KVIrc. :)
*/
