#ifndef _EDITORWINDOW_H_
#define _EDITORWINDOW_H_
//
//   File : editorwindow.h
//   Creation date : Mon Sep 11 2000 12:26:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qmenubar.h>
#include <qlabel.h>

#include "editor.h"
#include "kvi_window.h"

class KviFrame;

class KviEditorWindow : public KviWindow
{
	Q_OBJECT
public:
	KviEditorWindow(KviFrame * lpFrm,const char * nam);
	~KviEditorWindow();
private:
	SSEXEditor   * m_pEditor;
	QMenuBar     * m_pMenuBar;
	QLabel       * m_pStatusLabel;
	QLabel       * m_pRowColLabel;
protected:
	virtual void resizeEvent(QResizeEvent *e);
	virtual void closeEvent(QCloseEvent *e);
	virtual void fillCaptionBuffers();
	virtual QPixmap * myIconPtr();
	void updateStatusLabel();
protected slots:
	void fileNameChanged(SSEXEditor *,const QCString &);
	void openFile();
	void newFile();
	void modifyStateChanged(SSEXEditor *ed,bool bModified);
	void saved(const QCString &fileName);
	void modeChanged(SSEXEditor *ed,SSEXEditor::ColorMode mode);
	void cursorPositionChanged(SSEXEditor *ed,int row,int col);
	void recordingKeystrokes(bool bRecording);
//	void rightClickOnTextRow(SSEXEditor *ed,const QCString &text,int charIndex,QPopupMenu *contextPopup);
//	void textMessage(SSEXEditor *ed,const QCString &msg);
public:
	SSEXEditor * editor(){ return m_pEditor; };
	virtual QSize sizeHint() const;
};

#endif //_EDITORWINDOW_H_
