//
//   File : editorwindow.cpp
//   Creation date : Mon Sep 11 2000 12:32:44 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "editorwindow.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_module.h"
#include "kvi_iconmanager.h"
#include "kvi_options.h"

#ifdef Unsorted
	#undef Unsorted
#endif

#include <qfiledialog.h>
#include <qpopupmenu.h>

extern KviPtrList<KviEditorWindow> * g_pEditorWindowList;


KviEditorWindow::KviEditorWindow(KviFrame * lpFrm,const char * nam)
: KviWindow(KVI_WINDOW_TYPE_EDITOR,lpFrm,nam)
{
//	g_pEditorModule->lock();
	g_pEditorWindowList->append(this);

	m_pEditor = new SSEXEditor(this);
	m_pMenuBar = new QMenuBar(this);
	m_pStatusLabel = new QLabel("",this);
	m_pRowColLabel = new QLabel(__tr("Row:0 Col:0"),this);

	QPopupMenu * file = new QPopupMenu(this);
	file->insertItem(__tr("&New"),this,SLOT(newFile()));
	file->insertItem(__tr("&Open"),this,SLOT(openFile()));

	file->insertItem(__tr("&Save"),m_pEditor,SLOT(saveFile()));
	file->insertItem(__tr("Save &As.."),m_pEditor,SLOT(saveFileAs()));

	file->insertSeparator();
	file->insertItem(__tr("&Close"),this,SLOT(close()));

	QPopupMenu * edit = new QPopupMenu(this);
	edit->insertItem(__tr("&Toggle find widget"),m_pEditor,SLOT(toggleFindWidget()));
	edit->insertItem(__tr("&Switch mode"),m_pEditor,SLOT(switchMode()));

	m_pMenuBar->insertItem(__tr("&File"),file);	
	m_pMenuBar->insertItem(__tr("&Edit"),edit);

	connect(m_pEditor,SIGNAL(fileNameChanged(SSEXEditor *,const QCString &)),
		this,SLOT(fileNameChanged(SSEXEditor *,const QCString &)));

	connect(m_pEditor,SIGNAL(modifyStateChanged(SSEXEditor *,bool)),
		this,SLOT(modifyStateChanged(SSEXEditor *,bool)));

	connect(m_pEditor,SIGNAL(saved(const QCString &)),
		this,SLOT(saved(const QCString &)));

	connect(m_pEditor,SIGNAL(modeChanged(SSEXEditor *,SSEXEditor::ColorMode)),
		this,SLOT(modeChanged(SSEXEditor *,SSEXEditor::ColorMode)));

	connect(m_pEditor,SIGNAL(cursorPositionChanged(SSEXEditor *,int,int)),
		this,SLOT(cursorPositionChanged(SSEXEditor *,int,int)));

	connect(m_pEditor,SIGNAL(recordingKeystrokes(bool)),
		this,SLOT(recordingKeystrokes(bool)));

	setFocusHandlerNoChildren(m_pEditor);

	updateStatusLabel();
}

KviEditorWindow::~KviEditorWindow()
{
	g_pEditorWindowList->removeRef(this);
//	if(g_pEditorWindowList->isEmpty())g_pEditorModule->unlock();
}

void KviEditorWindow::fillCaptionBuffers()
{
	KviStr fName = m_pEditor->fileName().data();
	if(fName.isEmpty())fName = __tr("Unnamed");
	m_szPlainTextCaption.sprintf("Editor: %s",fName.ptr());
	m_szHtmlActiveCaption.sprintf("<nobr><font color=\"%s\"><b>Editor: %s</b></font></nobr>",
		KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name().ascii(),fName.ptr());
	m_szHtmlInactiveCaption.sprintf("<nobr><font color=\"%s\"><b>Editor: %s</b></font></nobr>",
		KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name().ascii(),fName.ptr());
}

void KviEditorWindow::resizeEvent(QResizeEvent *e)
{
	int hght = m_pMenuBar->sizeHint().height();
	int hght2 = m_pStatusLabel->sizeHint().height();
	m_pMenuBar->setGeometry(0,0,width(),hght);
	m_pEditor->setGeometry(0,hght,width(),height() - (hght + hght2));
	int wdth = (width() * 75) / 100;
	m_pStatusLabel->setGeometry(0,height() - hght2,wdth,hght2);
	m_pRowColLabel->setGeometry(wdth,height() - hght2,width() - wdth,hght2);
}

QSize KviEditorWindow::sizeHint() const
{
	return QSize(m_pEditor->sizeHint().width(),m_pEditor->sizeHint().height() + 
			m_pMenuBar->sizeHint().height());
}

QPixmap * KviEditorWindow::myIconPtr()
{
	return g_pIconManager->getSmallIcon(KVI_SMALLICON_EDITOR);
}

void KviEditorWindow::closeEvent(QCloseEvent *e)
{
	if(m_pEditor->closeFile())KviWindow::closeEvent(e);
	else e->ignore();
}

void KviEditorWindow::fileNameChanged(SSEXEditor *,const QCString &)
{
	updateCaption();
}

void KviEditorWindow::openFile()
{
	KviStr tmp = QFileDialog::getOpenFileName();
	if(tmp.hasData())
	{
		KviStr fName = m_pEditor->fileName().data();
		if((kvi_strEqualCS(fName.ptr(),"unnamed") || fName.isEmpty()) && (!m_pEditor->isModified()))
		{
			// open in this window
			m_pEditor->loadFile(tmp.ptr());
		} else {
			// open in another window
			KviEditorWindow *w = new KviEditorWindow(m_pFrm,__tr("Text editor"));
			w->editor()->loadFile(tmp.ptr());
			m_pFrm->addWindow(w);
		}
	}
}

void KviEditorWindow::newFile()
{
	KviEditorWindow * w = new KviEditorWindow(m_pFrm,__tr("Text editor"));
	m_pFrm->addWindow(w);
}

void KviEditorWindow::modifyStateChanged(SSEXEditor *,bool)
{
	updateStatusLabel();
}

void KviEditorWindow::saved(const QCString &)
{
	updateStatusLabel();
}

void KviEditorWindow::modeChanged(SSEXEditor *,SSEXEditor::ColorMode)
{
	updateStatusLabel();
}

void KviEditorWindow::cursorPositionChanged(SSEXEditor *,int row,int col)
{
	KviStr tmp(KviStr::Format,__tr("Row:%d Col:%d"),row,col);
	m_pRowColLabel->setText(tmp.ptr());
}

void KviEditorWindow::recordingKeystrokes(bool)
{
	updateStatusLabel();
}

void KviEditorWindow::updateStatusLabel()
{
	KviStr tmp;
	switch(m_pEditor->mode())
	{
		case SSEXEditor::Normal:
			tmp = __tr("Normal mode");
		break;
		case SSEXEditor::Cpp:
			tmp = __tr("Cpp mode");
		break;
		case SSEXEditor::Html:
			tmp = __tr("Html mode");
		break;
		default:
			tmp = __tr("Unknown mode");
		break;
	}
	if(m_pEditor->isModified())tmp.append(__tr(", modified"));
//	if(m_pEditor->recordingKeystrokes())tmp.append(__tr(", recording keystrokes"));
	m_pStatusLabel->setText(tmp.ptr());
}

#include "m_editorwindow.moc"
